% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log10_ticks.R
\name{log10_ticks}
\alias{log10_ticks}
\title{Logarithmic axis tick marks}
\usage{
log10_ticks(x, label_zero = TRUE)
}
\arguments{
\item{x}{A vector of axis values. Can be arbitrarily long but only the
minimum and maximum are necessary.}

\item{label_zero}{Whether or not to replace the smallest major label with
"0". This defaults to \code{TRUE} and is useful for some types of plots
used to display concentration-response data where the leftmost data point
represents the control.}
}
\value{
A list with the positions and labels of the major and minor tick
  marks. The labels are formatted without trailing zeros using
  \code{formatC(labels, format = "fg")}.
}
\description{
Calculate the positions and labels of major and minor tick marks for a base
10 logarithmic axis.
}
\examples{
x <- c(0.01, 0.2, 3, 10, 50)
plot(x, c(5, 4, 2.5, 1, 0), xaxt = "n", log = "x")
ticks <- log10_ticks(x)
axis(1, at = ticks$major, labels = ticks$major_labels)
axis(1, at = ticks$minor, labels = FALSE, tcl = -0.25)

}
