% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_RandomRBFGeneratorEvents.R
\name{DSD_RandomRBFGeneratorEvents}
\alias{DSD_RandomRBFGeneratorEvents}
\title{Random RBF Generator Events Data Stream Generator}
\usage{
DSD_RandomRBFGeneratorEvents(
  k = 3,
  d = 2,
  numClusterRange = 3L,
  kernelRadius = 0.07,
  kernelRadiusRange = 0,
  densityRange = 0,
  speed = 100L,
  speedRange = 0L,
  noiseLevel = 0.1,
  noiseInCluster = FALSE,
  eventFrequency = 30000L,
  eventMergeSplitOption = FALSE,
  eventDeleteCreate = FALSE,
  modelSeed = NULL,
  instanceSeed = NULL
)
}
\arguments{
\item{k}{The average number of centroids in the model.}

\item{d}{The dimensionality of the data.}

\item{numClusterRange}{Range for number of clusters.}

\item{kernelRadius}{The average radius of the micro-clusters.}

\item{kernelRadiusRange}{Deviation of the number of centroids in the model.}

\item{densityRange}{Density range.}

\item{speed}{Kernels move a predefined distance of 0.01 every X points.}

\item{speedRange}{Speed/Velocity point offset.}

\item{noiseLevel}{Noise level.}

\item{noiseInCluster}{Allow noise to be placed within a cluster.}

\item{eventFrequency}{Frequency of events.}

\item{eventMergeSplitOption}{Merge and split?}

\item{eventDeleteCreate}{Delete and create?}

\item{modelSeed}{Random seed for the model.}

\item{instanceSeed}{Random seed for the instances.}
}
\value{
An object of class \code{DSD_RandomRBFGeneratorEvent} (subclass of
\link{DSD_MOA}, \link[stream:DSD]{stream::DSD}).
}
\description{
A class that generates random data based on RandomRBFGeneratorEvents
implemented in MOA.
}
\details{
There are an assortment of parameters available for the underlying MOA data
structure, however, we have currently limited the available parameters to
the arguments above.  Currently the \code{modelSeed} and \code{instanceSeed} are set to
default values every time a \link{DSD_MOA} is created, therefore the
generated data will be the same. Because of this, it is important to set the
seed manually when different data is needed.

The default behavior is to create a data stream with 3 clusters and concept
drift.  The locations of the clusters will change slightly, and they will
merge with one another as time progresses.
}
\examples{
stream <- DSD_RandomRBFGeneratorEvents()
get_points(stream, 10)

if (interactive()) {
animate_data(stream, n = 5000, horizon = 100, xlim = c(0, 1), ylim = c(0, 1))
}
}
\references{
Albert Bifet, Geoff Holmes, Bernhard
Pfahringer, Philipp Kranen, Hardy Kremer, Timm Jansen, Thomas Seidl.
MOA: Massive Online Analysis, a Framework for Stream
Classification and Clustering
\emph{Journal of Machine Learning Research (JMLR)}, 2010.
}
\seealso{
Other DSD_MOA: 
\code{\link{DSD_MOA}()}
}
\author{
Michael Hahsler and John Forrest
}
\concept{DSD_MOA}
