% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_MOA.R
\name{DSC_MOA}
\alias{DSC_MOA}
\title{DSC_MOA Class}
\usage{
DSC_MOA(...)
}
\arguments{
\item{...}{further arguments.}
}
\description{
An abstract class that inherits from the base class \link[stream:DSC]{stream::DSC} and provides the
common functions needed to interface MOA clusterers.
}
\details{
\code{DSC_MOA} is a subclass of \link[stream:DSC]{stream::DSC} for MOA-based clusterers.
\code{DSC_MOA} classes operate in a different way in that the centers of the
micro-clusters have to be extracted from the underlying Java object. This is
done by using \pkg{rJava} to perform method calls directly in the JRI and
converting the multi-dimensional Java array into a local R data type.

\strong{Note:} The formula interface is currently not implemented for MOA-based clusterers.
Use \link[stream:DSF]{stream::DSF} to select features instead.
}
\references{
Albert Bifet, Geoff Holmes, Richard Kirkby, Bernhard Pfahringer
(2010). MOA: Massive Online Analysis, Journal of Machine Learning Research
11: 1601-1604
}
\seealso{
Other DSC_MOA: 
\code{\link{DSC_BICO_MOA}()},
\code{\link{DSC_CluStream}()},
\code{\link{DSC_ClusTree}()},
\code{\link{DSC_DStream_MOA}()},
\code{\link{DSC_DenStream}()},
\code{\link{DSC_MCOD}()},
\code{\link{DSC_StreamKM}()}
}
\author{
Michael Hahsler and John Forrest
}
\concept{DSC_MOA}
