/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.SparseInstance;
import java.util.ArrayList;
import java.util.Random;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class TextGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 3028905554604259131L;
    public IntOption numAttsOption = new IntOption("numAtts", 'a', "The number of attributes to generate.", 1000, 0, Integer.MAX_VALUE);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected int[] wordTwitterGenerator;
    protected double[] freqTwitterGenerator;
    protected double[] sumFreqTwitterGenerator;
    protected int[] classTwitterGenerator;
    protected int sizeTable;
    protected double probPositive = 0.1;
    protected double probNegative = 0.1;
    protected double zipfExponent = 1.5;
    protected double lengthTweet = 15.0;
    protected int countTweets = 0;

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public InstanceExample nextInstance() {
        int[] votes;
        double[] attVals = new double[this.numAttsOption.getValue() + 1];
        do {
            int length;
            if ((length = (int)(this.lengthTweet * (1.0 + this.instanceRandom.nextGaussian()))) < 1) {
                length = 1;
            }
            votes = new int[3];
            for (int j = 0; j < length; ++j) {
                int mid;
                double rand = this.instanceRandom.nextDouble();
                boolean i = false;
                int min = 0;
                int max = this.sizeTable - 1;
                do {
                    if (rand > this.sumFreqTwitterGenerator[mid = (min + max) / 2]) {
                        min = mid + 1;
                        continue;
                    }
                    max = mid - 1;
                } while (this.sumFreqTwitterGenerator[mid] != rand && min <= max);
                attVals[this.wordTwitterGenerator[mid]] = 1.0;
                int n = this.classTwitterGenerator[mid];
                votes[n] = votes[n] + 1;
            }
        } while (votes[1] == votes[2]);
        SparseInstance inst = new SparseInstance(1.0, attVals);
        inst.setDataset(this.getHeader());
        inst.setClassValue(votes[1] > votes[2] ? 0.0 : 1.0);
        ++this.countTweets;
        return new InstanceExample(inst);
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        int i;
        this.sizeTable = this.numAttsOption.getValue();
        this.wordTwitterGenerator = new int[this.sizeTable];
        this.freqTwitterGenerator = new double[this.sizeTable];
        this.sumFreqTwitterGenerator = new double[this.sizeTable];
        this.classTwitterGenerator = new int[this.sizeTable];
        this.countTweets = 0;
        double sum = 0.0;
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        for (i = 0; i < this.sizeTable; ++i) {
            this.wordTwitterGenerator[i] = i + 1;
            this.freqTwitterGenerator[i] = 1.0 / Math.pow(i + 1, this.zipfExponent);
            this.sumFreqTwitterGenerator[i] = sum += this.freqTwitterGenerator[i];
            double rand = this.instanceRandom.nextDouble();
            this.classTwitterGenerator[i] = rand < this.probPositive ? 1 : (rand < this.probNegative + this.probPositive ? 2 : 0);
        }
        i = 0;
        while (i < this.sizeTable) {
            int n = i;
            this.freqTwitterGenerator[n] = this.freqTwitterGenerator[n] / sum;
            int n2 = i++;
            this.sumFreqTwitterGenerator[n2] = this.sumFreqTwitterGenerator[n2] / sum;
        }
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.generateHeader();
        this.restart();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    private void generateHeader() {
        ArrayList<String> classLabels = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            classLabels.add("class" + (i + 1));
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < this.numAttsOption.getValue(); ++i) {
            attributes.add(new Attribute("att" + (i + 1), classLabels));
        }
        attributes.add(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
    }

    public void changePolarity(int numberWords) {
        int i = 0;
        while (i < numberWords) {
            int randWord = this.instanceRandom.nextInt(this.sizeTable);
            int polarity = this.classTwitterGenerator[randWord];
            if (polarity == 1) {
                this.classTwitterGenerator[i] = 2;
                ++i;
            }
            if (polarity != 2) continue;
            this.classTwitterGenerator[i] = 1;
            ++i;
        }
    }

    public void changeFreqWords(int numberWords) {
        for (int i = 0; i < numberWords; ++i) {
            int randWordFrom;
            int randWordTo = this.instanceRandom.nextInt(this.sizeTable);
            this.wordTwitterGenerator[randWordTo] = randWordFrom = this.instanceRandom.nextInt(this.sizeTable);
            this.wordTwitterGenerator[randWordFrom] = randWordTo;
        }
    }
}

