% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_functions.R
\name{strata_match_nstrat}
\alias{strata_match_nstrat}
\title{Match without Stratification}
\usage{
strata_match_nstrat(object, model = NULL, k = 1)
}
\arguments{
\item{object}{a strata object}

\item{model}{(optional) formula for matching.  If left blank, \emph{all}
columns of the analysis set in \code{object} will be used as covariates in
the propensity model or mahalanobis match (except outcome, treatment and
stratum)}

\item{k}{the number of control individuals to be matched to each treated
individual.  If \code{"k = full"} is used, fullmatching is done instead of
pairmatching}
}
\value{
a named factor with matching assignments
}
\description{
Not meant to be called externally.  Match a data set without stratifying.
Used to compare performance with and without stratification. Note that this 
function requires that the R package \code{optmatch} is installed.
}
\seealso{
\url{https://cran.r-project.org/package=optmatch}
}
\keyword{internal}
