% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WLRtest.R
\name{WLRtest}
\alias{WLRtest}
\title{This function performs weighted log-rank test.}
\usage{
WLRtest(time, event, group, rho = 0, gamma = 0)
}
\arguments{
\item{time}{time a vector of event or censored times.}

\item{event}{a vector with entries 0 or 1, indicating event occurrence (1) or time being censored (0).}

\item{group}{a vector indicating treatment groups.}

\item{rho}{a value of rho in Fleming-Harrington weight}

\item{gamma}{a value of gamma in Fleming-Harrington weight}
}
\value{
A list with components:
\item{z}{z value of weighted log-rank test.}
\item{pvalue.two.sided}{p-value for two-sided test.}
\item{pvalue.less}{p-value for one-sided test (less).}
\item{pvalue.greater}{p-value for one-sided test (greater).}
\item{D}{a matrix containing components that can be used in stratified max-combo test.}
}
\description{
This function performs weighted log-rank test.
}
\examples{
data(sim_data)
##load survival data
time <- sim_data$event_time
event <- sim_data$event_status
group <- sim_data$group

##perform weighted log-rank test
WLRtest(time,event,group,rho=0,gamma=0)

}
\references{
Ristl, R., Ballarini, N., Götte, H., Schüler, A., Posch, M. and König, F. (2021).
Delayed treatment effects, treatment switching and heterogeneous patient populations: How to design and analyze RCTs in oncology.
{\emph{Pharmaceutical Statistics.}, 20:129-145} \doi{10.1002/pst.2062}
}
\seealso{
\code{\link{SMCtest}}
}
