% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{strat}
\alias{strat}
\title{Stratification index.}
\usage{
strat(outcome, strata, weights = NULL, ordered = FALSE, group = NULL)
}
\arguments{
\item{outcome}{A numeric vector of outcome.}

\item{strata}{A vector of \code{length(outcome)} indicating strata
membership. The elements are coerced to factors by
\code{\link[base]{factor}}.}

\item{weights}{An optional vector of weights.}

\item{ordered}{Logical. If \code{TRUE} strata are pre-ordered ascendingly.}

\item{group}{An optional grouping factor. If specified, \code{strat} also
returns between-group and within-group components of the overall
stratification.}
}
\value{
An object of class \code{strat}. \item{overall}{a vector of two,
  giving computed stratification index and approximate standard error.}
  \item{strata_info}{a data frame of stratum-specific information, including
  name, population share, and average percentile
  rank.}\item{decomposition}{between-group and within-group components of the
  overall stratification.}\item{within_group}{within-group indices of
  stratification by group.}
}
\description{
\code{strat} computes the stratification index proposed in Zhou (2012). When
\code{group} is specified, it also returns between-group and within-group
components of the overall stratification.
}
\examples{
s <- with(cpsmarch2015, strat(income, big_class,
 weights = weight, group = education))
print(s, digits = 4)
print(s$strata_info, digits = 4)
print(s$within_group, digits = 4)
}
\references{
Zhou, Xiang. 2012. "A Nonparametric Index of Stratification."
  Sociological Methodology, 42(1): 365-389.
}

