% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{t_list}
\alias{t_list}
\title{Transpose a List}
\usage{
t_list(x, rtn.atomic = FALSE)
}
\arguments{
\item{x}{list where each element has the same structure.}

\item{rtn.atomic}{logical vector of length 1 specifying whether the returned list
should be a list of atomic vectors (TRUE) rather than a list of lists (FALSE).}
}
\value{
list where each element is from those in \code{x[[1]]} and each element
of the returned object has a subelement for each element in \code{x}.
}
\description{
\code{t_list} transposes a list, similar to what \code{t.default} does for matrices.
\code{t_list} assumes the structure of each \code{x} element is the same. Tests
are done to ensure the lengths and names are the same for each \code{x} element.
The returned list has list elements in the same order as in \code{x[[1]]}.
}
\details{
If any element within \code{x} has no names (NULL), then the transposition is
done based on positions. If all element within \code{x} have the same names,
then the transposition is done based on those names.
}
\examples{

# modeling example
iris_bySpecies <- split(x = iris, f = iris$"Species")
lmObj_bySpecies <- lapply(X = iris_bySpecies, FUN = function(dat) {
   lm(Sepal.Length ~ Petal.Width, data = dat)})
lmEl_bySpecies <- t_list(lmObj_bySpecies)
summary(lmObj_bySpecies); summary(lmEl_bySpecies)
summary.default(lmEl_bySpecies[[1]]); summary.default(lmEl_bySpecies[[2]])

# no names
lmObj_bySpecies2 <- unname(lapply(X = lmObj_bySpecies, FUN = unname))
lmEl_bySpecies2 <- t_list(lmObj_bySpecies2)
summary(lmObj_bySpecies2); summary(lmEl_bySpecies2)
summary.default(lmEl_bySpecies2[[1]]); summary.default(lmEl_bySpecies2[[2]])
all(unlist(Map(name = lmEl_bySpecies, nameless = lmEl_bySpecies2,
   f = function(name, nameless) all.equal(unname(name), nameless)))) # is everything
   # but the names the same?

# atomic vector example
x <- list("A" = c("a"=1,"b"=2,"c"=3),"B" = c("a"=1,"b"=2,"c"=3),
   "C" = c("a"=1,"b"=2,"c"=3))
t_list(x, rtn.atomic = TRUE)

# names in different positions
x <- list("A" = c("a"=1,"b"=2,"c"=3),"B" = c("b"=2,"a"=1,"c"=3),
   "C" = c("c"=3,"b"=2,"a"=1))
t_list(x, rtn.atomic = TRUE)

# no names
x <- list(c(1,2,3), c(1,2,3), c(1,2,3))
t_list(x, rtn.atomic = TRUE)

# lists with a single element
x <- list("A" = c("a"=1,"b"=2,"c"=3))
t_list(lmObj_bySpecies[1])
}
