% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{laynames}
\alias{laynames}
\title{Names of the Layers (the Third Dimension)}
\usage{
laynames(x)
}
\arguments{
\item{x}{array.}
}
\value{
Names of the layers (the third dimension) of \code{x}. The structure is
a character vector with length = \code{nlay(x)}. See details for special cases.
}
\description{
\code{laynames} returns the names of the layers - the third dimension - of an array.
If the object does not have a third dimension (e.g., matrix), then the function
will return NULL. If the object does not have any dimensions
(e.g., atomic vector), then the function will also return NULL.
}
\details{
R does not have standard terminology for the third dimension. There are several common terms
people use including "height" and "page". I personally prefer "layer" as it makes sense
whether the user visualizes the third dimension as going into/ontop a desk or into/ontop a wall.
}
\examples{
laynames(HairEyeColor)
a <- array(data = NA, dim = c(6,7,8,9))
laynames(a)
laynames(c(1,2,3))
}
