% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_meeting_agenda.R
\name{get_meeting_agenda}
\alias{get_meeting_agenda}
\title{Retreive agenda for a specified meeting}
\usage{
get_meeting_agenda(meetingid = NA, good_manners = 0)
}
\arguments{
\item{meetingid}{Character string indicating the id of the meeting to request all votes from}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{agenda_number} \tab The agenda number for the session \cr
   \strong{meeting_date} \tab Date of the meeting \cr
   \strong{meeting_id} \tab Meeting id \cr
   \strong{meeting_place} \tab Where the meeting was held \cr
   \strong{agenda_case_reference} \tab Reference for the case on the agenda \cr
   \strong{agenda_case_number} \tab Case number \cr
   \strong{agenda_case_text} \tab Case description \cr
   \strong{agenda_case_type} \tab Case type \cr
   \strong{footnote} \tab Footnote for the case \cr
   \strong{proposition_id} \tab If relevant, belonging proposition id \cr
   \strong{committee_id} \tab If relevant, id of the responsible committee \cr
   \strong{legacy_question_id} \tab Legacy question id, only used for mathing with old data (pre 10.12.2024) \cr
   \strong{loose_proposals} \tab Whether there are loose proposals to the case \cr
   \strong{case_id} \tab Id of the case \cr
   \strong{question_hour_type} \tab If relevant, type of question hour \cr
   \strong{question_id} \tab If relevant, question id \cr
}
}
\description{
A function for retrieving the agenda for a specific meeting.
}
\examples{

\dontrun{

meetings0910 <- get_session_meetings("2009-2010")
meeting_agenda <- get_meeting_agenda(meetings0910$meeting_id[161])
meeting_agenda
}
 
}
\seealso{
\link{get_session_meetings} \link{get_case} \link{get_question} \link{get_question_hour}
}
