% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srlaplace.R
\name{srlaplace}
\alias{srlaplace}
\alias{srlaplace_custom}
\title{Sampling from Laplace Distribution}
\usage{
srlaplace(n = 1, mu = 0, b = 1, x = NULL)

srlaplace_custom(n = 1, x = NULL)
}
\arguments{
\item{n}{Integer, length 1. Number of samples to draw.}

\item{mu}{Numeric, location parameter.}

\item{b}{Numeric, scale parameter.}

\item{x}{(optional) Numeric vector of length \eqn{n}. If provided, this vector is over
written in place to avoid any memory allocation.}
}
\value{
A numeric vector of length \code{n} containing samples from the Laplace Distribution with the specified
\code{mu} and \code{b}.

\bold{NOTE:} When the \code{x} parameter is specified, it is updated in-place with the simulation for performance reasons.
}
\description{
The \code{srlaplace()} function generates random samples from a Laplace Distribution using the STORS algorithm.
It employs an optimized proposal distribution around the mode and Inverse Transform (IT) method for the tails.
}
\details{
The Laplace distribution has the probability density function (PDF):
\eqn{f(x | \mu, b) = \frac{1}{2b} \exp\left(-\frac{|x - \mu|}{b}\right),}
where:
\describe{
\item{\eqn{\mu}}{is the location parameter (mean of the distribution).}
\item{\code{b}}{is the scale parameter, which controls the spread of the distribution (\code{b > 0}).}
}

These two functions are for sampling using the STORS algorithm based on the proposal that has been constructed using \code{\link{srlaplace_optimize}}.

By default, \code{srlaplace()} samples from a standard Laplace Distribution (\code{mu = 0}, \code{b = 1}).
The proposal distribution is pre-optimized at package load time using \code{srlaplace_optimize()} with
\code{steps = 4091}, creating a scalable proposal centred around the mode.

If \code{srlaplace()} is called with custom \code{mu} or \code{b} parameters, the samples are generated
from the standard Laplace Distribution, then scaled and location shifted accordingly.
}
\examples{
# Generate 10 samples from the standard Laplace Distribution
samples <- srlaplace(10)
print(samples)

# Generate 10 samples using a pre-allocated vector
x <- numeric(10)
srlaplace(10, x = x)
print(x)

# Generate 10 samples from a Laplace Distribution with mu = 2 and b = 3
samples <- srlaplace(10, mu = 2, b = 3)
print(samples)

}
\seealso{
\code{\link{srlaplace_optimize}} to optimize the custom or the scaled proposal.
}
