% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srbeta.R
\name{srbeta_custom}
\alias{srbeta_custom}
\title{Sampling from Beta Distribution}
\usage{
srbeta_custom(n = 1, x = NULL)
}
\arguments{
\item{n}{Integer, length 1. Number of samples to draw.}

\item{x}{(optional) Numeric vector of length \eqn{n}. If provided, this vector is overwritten in place to avoid any memory allocation.}
}
\value{
A numeric vector of length \code{n} containing random samples from the Beta distribution.
The \code{shape1} and \code{shape2} parameters are specified during the optimization process using \code{srbeta_optimize()}.

\bold{NOTE:} When the \code{x} parameter is specified, it is updated in-place with the simulation for performance reasons.
}
\description{
The \code{srbeta_custom()} function generates random samples from a Beta distribution using the STORS algorithm.
It employs an optimized proposal distribution around the mode and Adaptive Rejection Sampling (ARS) for the tails.
}
\details{
The Beta Distribution

The Beta distribution has the probability density function (PDF):
\deqn{f(x | \alpha, \beta) = \frac{\Gamma(\alpha + \beta)}{\Gamma(\alpha)\Gamma(\beta)} x^{\alpha - 1} (1 - x)^{\beta - 1}, \quad 0 \leq x \leq 1,}
where:
\describe{
\item{\eqn{\alpha}}{is the first shape parameter (\eqn{\alpha > 0}).}
\item{\eqn{\beta}}{is the second shape parameter (\eqn{\beta > 0}).}
}
The Beta distribution is widely used in Bayesian statistics and in modelling probabilities and proportions.
}
\note{
This function is not scalable. Therefore, only the \code{srbeta_custom()} version is available, which requires the proposal to be pre-optimized using \code{srbeta_optimize()} before calling this function.
}
\section{TODO : This density instead of this function.}{
This function samples from a proposal constructed using \code{\link{srbeta_optimize}}, employing the STORS algorithm.

By default, \code{srbeta_custom()} samples from the standard Beta distribution with \code{shape1 = 1} and \code{shape2 = 1}.
The proposal distribution is pre-optimized at package load time using \code{srbeta_optimize()} with
\code{steps = 4091}, creating a scalable proposal centred around the mode.
}

\examples{
# Generate 10 samples from Beta Distribution
samples <- srbeta_custom(10)
print(samples)

# Generate 10 samples using a pre-allocated vector
x <- numeric(10)
srbeta_custom(10, x = x)
print(x)

}
\seealso{
\code{\link{srbeta_optimize}} to optimize the custom proposal.
}
