% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.rule.tite.R
\name{table.rule.tite}
\alias{table.rule.tite}
\title{Tabulate Stopping Rule (TITE Method)}
\usage{
table.rule.tite(x, dec = 3)
}
\arguments{
\item{x}{A \code{rule.tite} object calculated by \code{calc.rule.tite()} function}

\item{dec}{Number of decimal places to which the stagewise effective sample sizes should be rounded}
}
\value{
A matrix with two columns: the ranges of effective sample sizes, and corresponding rejection boundaries for these ranges
}
\description{
Summarize a stopping rule in a condensed tabular format
}
\examples{

\dontrun{
# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
poc_rule = calc.rule.tite(n=50,p0=0.20,alpha=0.10,type="Pocock")

# Tabulate stopping boundary
table.rule.tite(poc_rule)
}
}
