% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\title{Calculate Various Performance Metrics}
\usage{
metrics(tickers = NULL, ..., gains = NULL, prices = NULL,
  perf.metrics = c("mean", "sd", "growth", "cagr", "mdd", "sharpe", "sortino",
  "alpha", "beta", "r.squared", "pearson", "spearman", "auto.pearson",
  "auto.spearman"))
}
\arguments{
\item{tickers}{Character vector of ticker symbols that Yahoo! Finance 
recognizes, if you want to download data on the fly.}

\item{...}{Arguments to pass along with \code{tickers} to 
\code{\link{load_gains}}.}

\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{perf.metrics}{Character vector specifying metrics to calculate.}
}
\value{
List containing:
\enumerate{
\item Numeric matrix named \code{perf.metrics} with performance metrics. 
\item Numeric matrix named \code{cor.mat} with correlation matrix for gains 
for the various investments.
}
}
\description{
Useful for comparing metrics for several investments. The first investment is 
used as the benchmark if requested metrics require one.
}
\examples{
\dontrun{
# Calculate performance metrics for SSO and UPRO, using SPY as benchmark 
# for alpha and beta
metrics1 <- metrics(tickers = c("SPY", "SSO", "UPRO"))
}


}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
