% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_graph.R
\name{growth_graph}
\alias{growth_graph}
\title{Graph Investment Growth}
\usage{
growth_graph(tickers = NULL, ..., gains = NULL, prices = NULL,
  initial = "10k", add.plot = FALSE, colors = NULL, lty = NULL,
  plot.list = NULL, points.list = NULL, grid.list = NULL,
  legend.list = NULL, pdf.list = NULL, bmp.list = NULL,
  jpeg.list = NULL, png.list = NULL, tiff.list = NULL)
}
\arguments{
\item{tickers}{Character vector of ticker symbols that Yahoo! Finance 
recognizes, if you want to download data on the fly.}

\item{...}{Arguments to pass along with \code{tickers} to 
\code{\link{load_gains}}.}

\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{initial}{Numeric value specifying what value to scale initial prices 
to. Can also be character string ending in "k", e.g. \code{"10k"} to graph 
growth of $10k without all the 0's.}

\item{add.plot}{Logical value for whether to add plot data to current plot 
frame rather than open a new one.}

\item{colors}{Character vector of colors for each curve.}

\item{lty}{Numeric vector specifying line types for each curve.}

\item{plot.list}{List of arguments to pass to \code{\link[graphics]{plot}}.}

\item{points.list}{List of arguments to pass to 
\code{\link[graphics]{points}}.}

\item{grid.list}{List of arguments to pass to \code{\link[graphics]{grid}}.}

\item{legend.list}{List of arguments to pass to 
\code{\link[graphics]{legend}}.}

\item{pdf.list}{List of arguments to pass to \code{\link[grDevices]{pdf}}.}

\item{bmp.list}{List of arguments to pass to \code{\link[grDevices]{bmp}}.}

\item{jpeg.list}{List of arguments to pass to \code{\link[grDevices]{jpeg}}.}

\item{png.list}{List of arguments to pass to \code{\link[grDevices]{png}}.}

\item{tiff.list}{List of arguments to pass to \code{\link[grDevices]{tiff}}.}
}
\value{
In addition to the graph, a list containing: 
\enumerate{
\item Numeric matrix named \code{prices} with prices for each investment.
\item Numeric vector named \code{means} with mean of gains for each 
investment.
\item Numeric matrix named \code{corr.matrix} with correlation matrix for 
gains for each investment.
}
}
\description{
Useful for comparing performance of investments over time.
}
\examples{
\dontrun{
# Plot growth of $10k in VFINX and BRK-B
fig <- growth_graph(c("VFINX", "BRK-B"))
}

}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
