% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{diffs}
\alias{diffs}
\title{Lagged Differences (Alternate Implementation)}
\usage{
diffs(x, lag = 1L)
}
\arguments{
\item{x}{Numeric vector.}

\item{lag}{Numeric value (e.g. 2 for differences between 1st and 3rd
element, 2nd and 4th, ...).}
}
\value{
Numeric vector.
}
\description{
Calculates differences between subsequent (or lagged) elements of a vector. 
Very similar to \code{\link[base]{diff}}, but written in C++.
}
\examples{
# Generate 1 million values from Poisson(3) distribution
x <- rpois(100000, 3)

# Calculate vector of differences between subsequent values
y <- diffs(x)

# Could get same result from base R function diff
z <- diff(x)
all.equal(y, z)

# But diffs is faster
benchmark(diffs(x), diff(x), replications = 100)


}
