% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_shareValueGGMNegativeGrowth.R
\name{shareValueGGMNegativeGrowth}
\alias{shareValueGGMNegativeGrowth}
\title{Valuing a share of stock using Gordon Growth Model with Negative Growth.}
\usage{
shareValueGGMNegativeGrowth(dividend, r, negG)
}
\arguments{
\item{dividend}{A number.}

\item{r}{A number.}

\item{negG}{A number.}
}
\value{
Input values to three arguments  \code{dividend} , \code{r} and \code{negG}.
}
\description{
The company named Afton Mines is a profitable venture that is expected to pay a $4.25 dividend next year. Because it is depleting its mining properties, the best estimate is that dividends will decline forever at a rate of 4 percent. The required rate of return on Afton stock is 9 percent. Compute the value of Afton share (Jerald E. Pinto, 2020).
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{shareValueGGMNegativeGrowth} is developed for Valuing a share of stock using Gordon Growth Model with Negative Growth for the values passed to its three arguments. Here, \code{dividend} is dollar value of the dividend, \code{r} is required rate of return and, \code{negG} represents the rate of decline in dividend.
}
\examples{
shareValueGGMNegativeGrowth(dividend=4.25,r=0.12,negG=-0.10)
shareValueGGMNegativeGrowth(dividend=4.25,r=0.12,negG=0.10)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
