% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_predictedPEbyFEDmodel.R
\name{predictedPEbyFEDmodel}
\alias{predictedPEbyFEDmodel}
\title{Calculates predicted value of Price to Earning Multiple based on yields on bonds.}
\usage{
predictedPEbyFEDmodel(tenYrBondYield)
}
\arguments{
\item{tenYrBondYield}{number.}
}
\value{
Input values to \code{tenYrBondYield}.
}
\description{
The US FED model based on a paper written by three analysts, Lander, Orphanides, and Douvogiannis in 1997, at the US Federal Reserve, predicts the return on the S&P 500 on the basis of the relationship between forecasted earnings yields and yields on bonds (as cited in Jerald E. Pinto, 2020).
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{predictedPEbyFEDmodel} is developed for computing predicted value of Price to Earning Multiple based on yields on bonds.
}
\examples{
predictedPEbyFEDmodel(tenYrBondYield=0.0293)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
