% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_justifiedTrailingPE.R
\name{justifiedTrailingPE}
\alias{justifiedTrailingPE}
\title{Calculates Justified Trailing P/E Based on the Gordon Growth Model.}
\usage{
justifiedTrailingPE(rCAPM, payoutRatio, g)
}
\arguments{
\item{rCAPM}{A number.}

\item{payoutRatio}{A number.}

\item{g}{A number.}
}
\value{
Input values to three arguments  \code{rCAPM} , \code{payoutRatio} and \code{g}.
}
\description{
The price-to-earnings ratio (P/E) is one of the most widely recognized valuation indicator and is familiar to readers of newspaper financial tables and institutional research reports. Using the Gordon growth model, an expression for P/E in terms of the fundamentals can be developed. Because P/E is so widely recognized, this method may be an effective way to communicate the analysis. Leading and trailing justified P/E expressions can be developed from the Gordon growth model. Assuming that the model can be applied to valuation of a particular stock, the dividend payout ratio is considered fixed. In trailing P/E, current price  is divided by trailing (current year) earnings (Jerald E. Pinto, 2020).
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{justifiedTrailingPE} is developed for computing Justified Trailing P/E Based on the Gordon Growth Model for the values passed to its three arguments. Here, \code{rCAPM} is required rate of return based on CAPM (Capital Asset Pricing Model), \code{payoutRatio} is payout ration and \code{g} is dividend growth rate.
}
\examples{
justifiedTrailingPE(rCAPM=0.09,payoutRatio=0.32,g=0.07)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
