% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/48_computingPS.R
\name{computingPS}
\alias{computingPS}
\title{Calculates Price to Sales (PS) Multiple as trailing PS or GGM based PS.}
\usage{
computingPS(PS = c("trialing", "GGM"), currentShPrice, payout, EPS0, S0, g, r)
}
\arguments{
\item{PS}{character vector.}

\item{currentShPrice}{number.}

\item{payout}{number.}

\item{EPS0}{number.}

\item{S0}{number.}

\item{g}{number.}

\item{r}{number.}
}
\value{
Input values to seven arguments  \code{PS}, \code{currentShPrice}, \code{payout}, \code{EPS0},\code{S0}, \code{g}, and \code{r}.
}
\description{
Certain types of privately held companies, including investment management companies and many types of companies in partnership form, have long been valued by a multiple of annual revenues. In recent decades, the ratio of price to sales has become well known as a valuation indicator for the equity of publicly traded companies as well. Analyst use PS Multiple as Sales are generally less subject to distortion or manipulation than are other fundamentals, such as EPS or book value. For example, through discretionary accounting decisions about expenses, company managers can distort EPS as a reflection of economic performance. In contrast, total sales, as the top line in the income statement, is prior to any expenses.Although the determination of sales is more straightforward than the determination of earnings, the analyst should evaluate a company’s revenue recognition practices, in particular, those tending to speed up the recognition of revenues—before relying on the P/S multiple. Trailing PS is calculated as price per share divided by annual net sales per share (net sales is total sales minus returns and customer discounts).Like other multiples, PS can be based on forecasted fundamentals like growth based on Gordon growth model (Jerald E. Pinto, 2020).
}
\details{
According to information provided in Jerald E. Pinto (2020), the method \code{computingPS} is developed for computing Price to Sales (PS) Multiple as trailing PS or GGM based PS for the values passed to its seven arguments. Here, \code{PS} is character string, either trialing or GGM , \code{currentShPrice} is current Share Price , \code{payout} is payout ratio,\code{EPS0} is current earnings per share, \code{S0} is sales per share, \code{g} is earnings growth rate, and  \code{r} is required rate of return on equity.
}
\examples{
computingPS("trailing", currentShPrice=20,payout=0.35,EPS0=0.9,S0=10,g=0.07,r=0.09)
computingPS("GGM",  currentShPrice=20,payout=0.35,EPS0=0.9,S0=10,g=0.07,r=0.09)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
