% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_rotor_grids.R
\name{get_phi_grid}
\alias{get_phi_grid}
\title{Grid with angles between points \eqn{(x, y)} and the rotor's vertical axis}
\usage{
get_phi_grid(x_grid, y_grid)
}
\arguments{
\item{x_grid}{A 2D array, with horizontal distances \eqn{x} from the rotor's
vertical axis, expressed as the proportion of rotor radius, for the
left-half of the rotor circle area.}

\item{y_grid}{A 2D array, with vertical distances (\eqn{y} from the rotor's
horizontal axis, expressed as the proportion of rotor radius, for the
left-half of the rotor circle area.}
}
\value{
A 2D array, giving a grid of angles (in radians) between points
\eqn{(x, y)} inside the rotor circle and the rotor center, for the
left-half of the rotor circle area.
}
\description{
Given grids of vertical and horizontal distances from rotor axes
at points \eqn{(x, y)} inside the rotor circle, \code{get_phi_grid}
calculates the associated radial angles, relative to the rotor vertical axis.

Returned grid represents the left-half of the rotor's circle.
}
\examples{
 x_grid <- get_x_grid(yinc=0.05, xinc=0.05)
 y_grid <- get_y_grid(x_grid,yinc=0.05)
 get_phi_grid(x_grid,y_grid)
}
\seealso{
\code{\link[=get_x_grid]{get_x_grid()}}, \code{\link[=get_y_grid]{get_y_grid()}}
}
