% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plot_k_trend}
\alias{plot_k_trend}
\title{Plot carrying capacity (k) trend}
\usage{
plot_k_trend(x, summary_stat = "mean", return_data = FALSE, ...)
}
\arguments{
\item{x}{a simulation_results object}

\item{summary_stat}{how to summarize the values across the landscape - "mean" (default)
or "sum"}

\item{return_data}{(TRUE/FALSE) should the data used to create the plots be returned?}

\item{...}{further arguments passed to/from other methods}
}
\description{
Plot linear graphs to illustrate carrying capacity changes through time.
}
\examples{

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = kernel_dispersal(max_distance = 2000,
                                        dispersal_kernel = exponential_dispersal_kernel(
                                          distance_decay = 1000)),
                          density_dependence = ceiling_density())

sim <- simulation(landscape = ls,
                  population_dynamics = pd,
                  habitat_dynamics = NULL,
                  timesteps = 20)

# Plot the carrying capacity trajectories
plot_k_trend(sim)
}
}
