% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupFuncs.R
\name{intersect_GroupAssignment}
\alias{intersect_GroupAssignment}
\title{Intersect two GroupAssignment}
\usage{
intersect_GroupAssignment(
  GA1,
  GA2,
  force_disjoint = TRUE,
  force_exhaustive = FALSE
)
}
\arguments{
\item{GA1, GA2}{\emph{GroupAssignment} objects to intersect. No previously intersected
objects can be intersected again.}

\item{force_disjoint}{\emph{boolean} indicating if groups disjointedness should be
forced in case when one observation would end in multiple intersections.
If \code{TRUE}, observation will remain only in the first intersection to which
it will be assigned. Default to \code{TRUE}.}

\item{force_exhaustive}{\emph{boolean} indicating if elements that are not assigned
to any of the intersecting groups should be gathered together in \code{.NA:.NA} group}
}
\value{
\emph{GroupAssignment} object with intersected groups.
}
\description{
You can intersect two GroupAssignment with this function.
}
\examples{
sex_grouping <- GroupConditions(
  conditions_category = "Sex",
  "M" ~ sex == "M",
  "F" ~ sex == "F",
  "O" ~ !sex \%in\% c("M", "F")
)

age_grouping <- GroupConditions(
  conditions_category = "Age",
  "to 20" ~ age < 20,
  "20 to 40" ~ age >= 20 & age <= 40,
  "40 to 60" ~ age >= 40 & age < 60,
  force_exhaustive = TRUE,
  force_disjoint = FALSE
)

# intersect two distinct GroupAssignements

intersected <- intersect_GroupAssignment(
  GA1 = GroupAssignment(HEXACO_60, sex_grouping),
  GA2 = GroupAssignment(HEXACO_60, age_grouping),
  force_exhaustive = TRUE,
  force_disjoint = FALSE
)

summary(intersected)

}
\seealso{
Other observation grouping functions: 
\code{\link{GroupAssignment}()},
\code{\link{extract_observations}()}
}
\concept{observation grouping functions}
