% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrequencyTable.R
\name{GroupedFrequencyTable}
\alias{GroupedFrequencyTable}
\alias{print.GroupedFrequencyTable}
\alias{summary.GroupedFrequencyTable}
\title{Create GroupedFrequencyTable}
\usage{
GroupedFrequencyTable(
  data,
  conditions,
  var,
  force_disjoint = FALSE,
  .all = TRUE
)

\method{print}{GroupedFrequencyTable}(x, ...)

\method{summary}{GroupedFrequencyTable}(object, ...)
}
\arguments{
\item{data}{source \code{data.frame}}

\item{conditions}{up to two \code{GroupConditions} objects. These objects will be
passed along during creation of higher-level objects and used when
\code{\link[=normalize_scores_grouped]{normalize_scores_grouped()}} will be called. If two objects are provided,
then intersection of groups will be made.}

\item{var}{name of variable to compute \code{GroupedFrequencyTable} for}

\item{force_disjoint}{It is recommended to keep it as default
\code{FALSE}, unless the sample size is very big and it is completely mandatory
to have the groups disjointed.}

\item{.all}{should \emph{.all} or \emph{.all1} and \emph{.all2} groups
be generated. If they are not generated, all score normalization
procedures will fail if the observation can't be assigned to any of the
provided conditions (eg. because of missing data), leaving it's score as \code{NA}.
Defaults to \code{TRUE}}

\item{x}{A \code{GroupedFrequencyTable} object}

\item{...}{further arguments passed to or from other methods.}

\item{object}{A \code{GroupedFrequencyTable} object}
}
\value{
\code{data.frame} of descriptive statistcs
}
\description{
Using \code{\link[=GroupConditions]{GroupConditions()}} object and source \code{data.frame} compute
a set of \code{\link[=FrequencyTable]{FrequencyTable()}}s for single variable
}
\details{
\code{force_exhaustive} will always be checked as \code{FALSE} during the
calculations. It is mandatory for validity of the created \emph{FrequencyTables}
}
\seealso{
plot.GroupedFrequencyTable
}
