% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sites.R
\name{ssar_sites}
\alias{ssar_sites}
\title{Get Sites}
\usage{
ssar_sites(
  projectid = NULL,
  start = NULL,
  results = 100,
  subdomain = Sys.getenv("SSAR_SUBDOMAIN"),
  apikey = Sys.getenv("SSAR_APIKEY")
)
}
\arguments{
\item{projectid}{The project id. If not provided then all sites will be returned.}

\item{start}{If more than \code{results} are available use \code{start} as pagination. Index starts at 0 (default).}

\item{results}{Default is 100. Max is 5000.}

\item{subdomain}{The account subdomain}

\item{apikey}{The api key from the account}
}
\value{
A table of the site information within a project
}
\description{
Retrieve a table of all the sites and metadata in a specified project
}
\examples{
\dontrun{
ssar_sites(projectid = {project_id}, #replace with your project id
           results = 300)
}

}
