% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{test.anova.bs}
\alias{test.anova.bs}
\title{Between-subjects F statistic and eta-squared from summary information}
\usage{
test.anova.bs(m, sd, n)
}
\arguments{
\item{m}{vector of estimated group means}

\item{sd}{vector of estimated group standard deviations}

\item{n}{vector of group sample sizes}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item F - F statistic for test of null hypothesis
\item dfA - degrees of freedom for between-subjects factor
\item dfE - error degrees of freedom
\item p - p-value
\item Eta-squared - estimate of eta-squared
\item adj Eta-squared - a bias adjusted estimate of eta-squared
}
}
\description{
Computes the F statistic, p-value, eta-squared, and adjusted eta-squared
for the main effect in a one-way between-subjects ANOVA using the estimated
group means, estimated group standard deviations, and group sample sizes.
}
\examples{
m <- c(12.4, 8.6, 10.5)
sd <- c(3.84, 3.12, 3.48)
n <- c(20, 20, 20)
test.anova.bs(m, sd, n)

#  Should return:
#        F dfA  dfE           p Eta-squared  adj Eta-squared
# 5.919585   2   57 0.004614428   0.1719831        0.1429298
 

}
