% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.yule}
\alias{size.ci.yule}
\title{Sample size for a Yule's Q confidence interval}
\usage{
size.ci.yule(alpha, p1, p2, Q, w)
}
\arguments{
\item{alpha}{alpha level for 1 - alpha confidence}

\item{p1}{planning value for row 1 marginal proportion}

\item{p2}{planning value for column 1 marginal proportion}

\item{Q}{planning value of Yule's Q}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate Yule's Q with desired
confidence interval precision. Set the Yule's Q planning value to the
smallest absolute value within a plausible range for a conservatively large
sample size.
}
\examples{
size.ci.yule(.05, .3, .2, .5, .4)

# Should return:
#  Sample size
#          354


}
