% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.cv2}
\alias{ci.ratio.cv2}
\title{Confidence interval for a ratio of coefficients of variation in a 2-group
design}
\usage{
ci.ratio.cv2(alpha, m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated ratio of coefficients of variation
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of population coefficients of
variation (CV) in a 2-group design. This confidence interval uses the
confidence interval for each CV and then uses the MOVER-DL method
(see Newcombe, page 138) to obtain a confidence interval for CV1/CV2.
The CV assumes ratio-scale scores.
}
\examples{
ci.ratio.cv2(.05, 34.5, 26.1, 4.15, 2.26, 50, 50)

# Should return:
# Estimate       LL       UL
# 1.389188 1.041478 1.854101
 

}
\references{
\insertRef{Newcombe2013}{statpsych}
}
