% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.median}
\alias{ci.median}
\title{Confidence interval for a median}
\usage{
ci.median(alpha, y)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated median
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a population median.
Tied scores are assumed to be rare.
}
\examples{
y <- c(30.2, 20.4, 15.1, 10.2, 10.5, 60.8, 20.8, 25.0, 20.7, 30.9, 10.8, 5.1,
         50.9, 40.0, 20.9, 10.8, 0, 20.5, 50.8)
ci.median(.05, y)

# Should return:
#  Estimate       SE   LL   UL
#      20.7 4.292277 10.8 30.9


}
\references{
\insertRef{Snedecor1980}{statpsych}
}
