% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleAcross.r
\name{sampleAcross}
\alias{sampleAcross}
\title{Permute values across two vectors or columns in two data frames or matrices}
\usage{
sampleAcross(..., by = NULL, replace = FALSE)
}
\arguments{
\item{...}{One or more vectors, data frames, or matrices (all objects must be the same class).}

\item{by}{Character list or list of integers. Names of columns or column numbers to permute (only used if \code{...} is data frames or matrices). If left as \code{NULL} (default) the all columns are permuted.}

\item{replace}{Logical. If \code{TRUE} then sample with replacement. If \code{FALSE} (default) then sample without replacement.}
}
\value{
A list object with same number of elements as in \code{...} with the original dimensions. The order is the same as in \code{...} (e.g., so if the call is like \code{sampleAcross(a, b, c)} then the output will be a list with permuted versions of \code{a}, \code{b}, and \code{c} in that order).
}
\description{
This function permutes values across two or more vectors or columns between two or more data frames or matrices. If vectors, then all values are swapped randomly and the output is a list object with vectors of the same length. If data frames or matrices, then values in selected columns are swapped across the data frames or matrices and the output is a list object with data frames or matrices of the same dimension as the originals.
}
\examples{

x1 <- 1:5
x2 <- 6:10
x3 <- 50:60
sampleAcross(x1, x2, x3)
sampleAcross(x1, x2, x3, replace=TRUE)

a <- data.frame(x=1:10, y=letters[1:10])
b <- data.frame(x=11:20, y=letters[11:20])
sampleAcross(a, b, by='y')
sampleAcross(a, b)

}
\seealso{
\code{\link[base]{sample}}
}
