% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlotData.R
\name{getPlotData}
\alias{getPlotData}
\alias{getPlotData.drc}
\alias{getPlotData.nls}
\alias{getPlotData.drcte}
\title{Get the data for plotting with ggplot()}
\usage{
getPlotData(obj, ...)

\method{getPlotData}{drc}(obj, xlim = NULL, gridsize = 100, type = c("average", "all"), ...)

\method{getPlotData}{nls}(obj, xlim = NULL, gridsize = 100, type = c("average", "all"), ...)

\method{getPlotData}{drcte}(
  obj,
  xlim = NULL,
  gridsize = 100,
  npmle.type = c("interpolation", "midpoint", "right", "left", "none"),
  ...
)
}
\arguments{
\item{obj}{A fitted model object. Methods are provided for drc, drcte and nls objects}

\item{...}{Other additional arguments.}

\item{xlim}{a vector. The interval for the predictor in which predictions are to be obtained}

\item{gridsize}{numeric. Number of points in the grid (within xlim) used for predictions.}

\item{type}{a character string specifying whether all the observed points should be plotted (type = "all")
or whether the response should be averaged over the levels of the predictor
(type = "all"). It is disregarded for drcte objects}

\item{npmle.type}{a character string. For drcte objects, the NPMLE of the cumulative
density function is only specified at the end of each inspection interval, while
 it is not unique within each interval. This argument specifies how the CDF
 increases within each interval: possible values are "interpolation" (it is
 assumed that the CDF increases progressively), "left" (the CDF increases at
 the beginning of each interval), "right" (the CDF increases at the end of each
 interval; it is very common in survival analysis) and "midpoint" (the CDF
 increases in the middle of each interval; it is very common in survival
 analysis). This argument is neglected with nls and drc objects.}
}
\value{
This function returns a list of two elements: 'plotPoints' is a dataframe containing
    the observed data, 'plotFits' is a dataframe containing model predictions
}
\description{
This method works on a model object and retrieves the data for plotting
the observed values (average or all data) and predictions from model fit.
It is mainly meant to be used with ggplot()
}
\examples{
fileName <- "https://www.casaonofri.it/_datasets/metamitron.csv"
metamitron <- read.csv(fileName)
mod <- drm(Conc ~ Time, fct = EXD.2(),
           data = metamitron, curveid = Herbicide)
retVal <- getPlotData(mod)
library(ggplot2)
ggplot() +
  geom_point(data = retVal$plotPoints, mapping = aes(x = Time, y = Conc)) +
  geom_line(data = retVal$plotFits, mapping = aes(x = Time, y = Conc)) +
  facet_wrap(~ Herbicide)

}
\author{
Andrea Onofri
}
