% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaotic_maps.R
\name{tent_map}
\alias{tent_map}
\title{A function to generate a time series from the logistic map}
\usage{
tent_map(N, mu, start="rand", disregard_N=0)
}
\arguments{
\item{N}{length of the time series that is to be generated}

\item{mu}{Tent map parameter, must be in the range [0,2]}

\item{start}{start value. Default is to random.}

\item{disregard_N}{Number of values at the beginning of the series to disregard}
}
\value{
A vector of length N
}
\description{
Generates a time series from the logistic map
}
\examples{
tent_map(N = 10^4, mu=1.8)
}
\references{
Feldman, D.P., McTague, C.S. and Crutchfield, J.P., 2008. The organization of intrinsic computation: Complexity-entropy diagrams and the diversity of natural information processing. Chaos: An Interdisciplinary Journal of Nonlinear Science, 18(4), p.043106.
}
\author{
Sebastian Sippel
}
