% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restart.R
\name{restart}
\alias{restart}
\title{Restarts R}
\usage{
restart(
  status = 0L,
  workdir = NULL,
  rcmd = NULL,
  args = NULL,
  envvars = NULL,
  as = c("current", "specified", "R CMD build", "R CMD check", "R CMD INSTALL"),
  quiet = FALSE,
  debug = NA
)
}
\arguments{
\item{status}{An integer specifying the exit code of the current
\R session.}

\item{workdir}{The working directory where the new \R session should
be launched from.  If \code{NULL}, then the working directory that was in
place when the \pkg{startup} package was first loaded.  If using
\code{startup::startup()} in an \file{.Rprofile} startup file, then this
is likely to record the directory from which \R itself was launched from.}

\item{rcmd}{A character string specifying the command for launching \R.
The default is the same as used to launch the current \R session, i.e.
\code{\link[base:commandArgs]{commandArgs()[1]}}.}

\item{args}{A character vector specifying zero or more command-line
arguments to be appended to the system call of \code{rcmd}.}

\item{envvars}{A named character vector of environment variables to
be set when calling \R.}

\item{as}{A character string specifying a predefined setups of \code{rcmd},
\code{args}, and \code{envvars}.  For details, see below.}

\item{quiet}{Should the restart be quiet or not?
If \code{NA} and \code{as == "current"}, then \code{quiet} is \code{TRUE} if the current
\R session was started quietly, otherwise \code{FALSE}.}

\item{debug}{If \code{TRUE}, debug messages are outputted, otherwise not.}
}
\description{
Restarts \R by quitting the current \R session and launching a new one.
}
\section{Predefined setups}{

Argument \code{as} may take the following values:
\describe{
\item{\code{"current"}:}{(Default) A setup that emulates the setup of the
current \R session as far as possible by relaunching \R with the same
command-line call (= \code{\link[base:commandArgs]{base::commandArgs()}}).
}
\item{\code{"specified"}:}{According to \code{rcmd}, \code{args}, and \code{envvars}.}
\item{\code{"R CMD build"}:}{A setup that emulates
\href{https://github.com/wch/r-source/blob/R-3-4-branch/src/scripts/build}{\verb{R CMD build}}
as far as possible.
}
\item{\code{"R CMD check"}:}{A setup that emulates
\href{https://github.com/wch/r-source/blob/R-3-4-branch/src/scripts/check}{\verb{R CMD check}}
as far as possible, which happens to be identical to the
\code{"R CMD build"} setup.
}
\item{\code{"R CMD INSTALL"}:}{A setup that emulates
\href{https://github.com/wch/r-source/blob/R-3-4-branch/src/scripts/INSTALL}{\verb{R CMD INSTALL}}
as far as possible.
}
}
If specified, command-line arguments in \code{args} and environment variables
in \code{envvars} are \emph{appended} accordingly.
}

\section{Known limitations}{

It is \emph{not} possible to restart an \R session running in \emph{RGui} on
Microsoft Windows using this function.

It is \emph{not} possible to restart an \R session in the RStudio \emph{Console}
using this function.  However, it does work when running \R in the
RStudio \emph{Terminal}.

RStudio provides \code{rstudioapi::restartSession()} which will indeed restart
the RStudio Console.  However, it does not let you control how \R is
restarted, e.g. with what command-line options and what environment
variables.  Importantly, the new \R session will have the same set of
packages loaded as before, the same variables in the global environment,
and so on.
}

\examples{
\dontrun{
  ## Relaunch R with debugging of startup::startup() enabled
  startup::restart(envvars = c(R_STARTUP_DEBUG = TRUE))

  ## Relaunch R without loading user Rprofile files
  startup::restart(args = "--no-init-file")

  ## Mimic 'R CMD build' and 'R CMD check'
  startup::restart(as = "R CMD build")
  startup::restart(as = "R CMD check")
  ## ... which are both short for
  startup::restart(args = c("--no-restore"),
                   envvars = c(R_DEFAULT_PACKAGES="", LC_COLLATE="C"))
}

}
