% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\docType{package}
\name{starnet-package}
\alias{starnet-package}
\title{Stacked Elastic Net Regression}
\description{
The R package \code{starnet} implements stacked elastic net regression.
The elastic net generalises ridge and lasso regularisation.
Instead of fixing or tuning the mixing parameter alpha,
we combine multiple alphas by stacked generalisation.
}
\details{
Use function \code{\link{starnet}} for model fitting.
Type \code{library(starnet)} and then \code{?starnet} or
\code{help("starnet)"} to open its help file.

See the vignette for further examples.
Type \code{vignette("starnet")} or \code{browseVignettes("starnet")}
to open the vignette.
}
\references{
\href{https://orcid.org/0000-0001-6498-4801}{Armin Rauschenberger},
\href{https://orcid.org/0000-0003-3977-7469}{Enrico Glaab},
and \href{https://orcid.org/0000-0003-4780-8472}{Mark A. van de Wiel}
(2021).
"Predictive and interpretable models via the stacked elastic net".
\emph{Bioinformatics} 37(14):2012-2016.
\doi{10.1093/bioinformatics/btaa535}.
(Click
\href{https://orbilu.uni.lu/bitstream/10993/43221/1/starnet.pdf}{here}
to access PDF.)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/rauschenberger/starnet/}
  \item \url{https://rauschenberger.github.io/starnet/}
  \item Report bugs at \url{https://github.com/rauschenberger/starnet/issues}
}

}
\author{
\strong{Maintainer}: Armin Rauschenberger \email{armin.rauschenberger@uni.lu} (\href{https://orcid.org/0000-0001-6498-4801}{ORCID})

}
\keyword{documentation}
