% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estima.R
\name{estima}
\alias{estima}
\title{Estimation of parameters of autologistic regression model for data on a grid}
\usage{
estima(data = 0, covariate1 = NULL, covariate2 = NULL,
  covariate3 = NULL, norm = "euclidean", vxpresent = 3,
  vypresent = 3, vxpast = 3, vypast = 3, dx = 1, dy = 1,
  swpresent = TRUE, swpast = TRUE, graph = FALSE, pastcov = FALSE,
  buildpres = NULL, buildpast = NULL)
}
\arguments{
\item{data}{dataset with the coordinates in the two first columns.}

\item{covariate1}{spatio-temporal covariate. The covariate dataframe must have \code{dim(data)[1] = dim(covariate)[1]} (same numbers of individuals) and \code{dim(data)[1] = dim(covariate)[1] + 3} as the covaiate dataset must not contain coordinates, but must match the coodinates of the dataset; and \code{T-1} years (\code{T} is the number of years in the dataset \code{"data"}) as the model needs the first year to initialize. See \code{"User guides, package vignettes and other documentation"} the \code{"estima"} vignette.}

\item{covariate2}{spatio-temporal covariate. The covariate dataframe must have \code{dim(data)[1] = dim(covariate)[1]} (same numbers of individuals) and \code{dim(data)[1] = dim(covariate)[1] + 3} as the covaiate dataset must not contain coordinates, but must match the coodinates of the dataset; and \code{T-1} years (\code{T} is the number of years in the dataset \code{"data"}) as the model needs the first year to initialize. See \code{"User guides, package vignettes and other documentation"} the \code{"estima"} vignette.}

\item{covariate3}{spatio-temporal covariate. The covariate dataframe must have \code{dim(data)[1] = dim(covariate)[1]} (same numbers of individuals) and \code{dim(data)[1] = dim(covariate)[1] + 3} as the covaiate dataset must not contain coordinates, but must match the coodinates of the dataset; and \code{T-1} years (\code{T} is the number of years in the dataset \code{"data"}) as the model needs the first year to initialize. See \code{"User guides, package vignettes and other documentation"} the \code{"estima"} vignette.}

\item{norm}{\code{"euclidean"}, \code{"inf"}, \code{"abs"}, \code{"lin"}. \code{norm = "euclidean"} by default. See vignette \code{Build}.}

\item{vxpresent}{positive real. Parameter of the ellipse for the tested neighborhood on x-axes in norm \code{"norm"} if \code{swpresent = FALSE}. If \code{swpresent = TRUE}, \code{vxpresent} will be the upper bound of the tested neighborhoods on x-axes in norm \code{norm}. See \code{swpresent}.}

\item{vypresent}{positive real. Parameter of the ellipse for the tested neighborhood on y-axes in norm \code{"norm"} if \code{swpresent = FALSE}. If \code{swpresent = TRUE}, \code{vypresent} will be the upper bound of the tested neighborhoods on y-axes in norm \code{norm}. See \code{swpresent}.}

\item{vxpast}{positive real. Parameter of the ellipse for the tested neighborhood on x-axes in norm \code{"norm"} if \code{swpast = FALSE}. If \code{swpast = TRUE}, \code{vxpast} will be the upper bound of the tested neighborhoods on x-axes in norm \code{norm}. See \code{swpast}. Only use if \code{pastcov = TRUE}.}

\item{vypast}{positive real. Parameter of the ellipse for the tested neighborhood on y-axes in norm \code{"norm"} if \code{swpast = FALSE}. If \code{swpast = TRUE}, \code{vypast} will be the upper bound of the tested neighborhoods on y-axes in norm \code{norm}. See \code{swpast}. Only use if \code{pastcov = TRUE}.}

\item{dx}{positive real : distance between sites on x-axis. \code{dx = 1} by default.}

\item{dy}{positive real : distance between sites on y-axis. \code{dy = 1} by default.}

\item{swpresent}{if \code{TRUE} the programm will test all possible neighborhood for the spatial autocorrelation (coefficient \code{rho1}) with parameters \code{vxmaxpresent}, \code{vymaxpresent}, \code{dx} and \code{dy}, otherwise the programm will test the neighborhood with the parameters \code{vxpresent} and \code{vypresent}. \code{swpresent = TRUE} by default.}

\item{swpast}{if \code{TRUE} the programm will test all possible neighborhood for the autoregression on on the sum of the \code{Zi,t-1} (coefficient Betapast) with parameters \code{vxmaxpast}, \code{vymaxpast}, \code{dx} and \code{dy}, otherwise the programm will test the neighborhood with the parameters \code{vxpast} and \code{vypast}. \code{swpast = TRUE} by default.}

\item{graph}{if \code{graph = TRUE}, the program will also return the plot of the dataset for the last time (and the year before if \code{estima = 3}). \code{graph = FALSE} by default.}

\item{pastcov}{boolen. If \code{pastcov = TRUE}, the function will use the past neighborhood as a covariate. See \code{"User guides, package vignettes and other documentation"} the \code{"estima"} vignette. \code{pastcov = FALSE} by default.}

\item{buildpres}{boolean which allow the use of a custom neighborhood matrix. \code{buildpres = NULL} by default.}

\item{buildpast}{boolean which allow the use of a custom neighborhood matrix. \code{buildpast = NULL} by default.}
}
\value{
list : estimate parameters using the pseudo-likelihood.
}
\description{
Estimation of parameters of autologistic regression model for data on a grid
}
\details{
See \code{"User guides, package vignettes and other documentation"} the \code{"estima"} vignette.
}
\examples{

data <- plantillness
v <- which(data$NRang <= 10)
data <- data[v,]
v <- which(data$NCep <= 10)
data<-data[v,]
result <- estima(data = data)



\donttest{
#Example in "lin" norm, with a fixed neighborhood :

result <- estima(data = plantillness, norm = "lin",swpresent = FALSE,vxpresent = 3, vypresent = 4)



#Example with a spatial covariate (adapted to the dimension of the dataset) :

cov <- covplant[,1]
for (i in (1:(dim(plantillness)[2] - 4))){
 cov <- cbind(cov,covplant[,1])
}
result <- estima(data = plantillness,covariate1 = cov)



#Example with the past neighborhood as covariate:

result <- estima(data = plantillness,pastcov = TRUE)



#Exemple with a custom neighborhood matrix

custompres <- build(data = plantillness)
custompast <- build(data = plantillness, vx = 5,vy = 6)
result <- estima(data = plantillness,pastcov = TRUE,buildpres = custompres,buildpast = custompast)

}

}
