DE <- list(H0 = list(profile = "H0", description = "Haushalt", details = "In dieses Profil werden alle Haushalte mit ausschließlichem und überwiegendem Privatverbrauch eingeordnet. Haushalte mit überwiegend privatem elektrischen Verbrauch, d.h. auch mit geringfügigem gewerblichen Bedarf sind z.B. Handelsvertreter, Heimarbeiter u.ä. mit Büro im Haushalt. Das Profil Haushalt ist nicht anwendbar bei Sonderanwendungen wie z.B. elektrischen Speicherheizungen oder Wärmepumpen."),
           G0 = list(profile = "G0", description = "Gewerbe allgemein",
                     details = "Ist eine Zuordnung zu einem der Gewerbeprofile G1 bis G6 nicht möglich oder gewollt, stellt dieses Profil den gewichteten Mittelwert der Gesamtgruppe dar."),
           G1 = list(profile = "G1", description = "Gewerbe werktags 8-18 Uhr",
                     details = "Dieses Profil repräsentiert Abnahmestellen, die typischerweise einen Verbrauch zwischen etwa 8 und 18 Uhr an den Werktagen, und keinen oder einen allenfalls geringen Verbrauch an den Wochenenden erwarten lassen (sonst siehe G4). Hierzu gehören u.a. Büros, Arzt- und Rechtsanwalts-Praxen, Werkstätten, Druckereien, Schulen, Kindergärten und Tagesstätten, Verwaltungseinrichtungen, Bankfilialen."),
           G2 = list(profile = "G2", description = "Gewerbe mit starkem bis überwiegendem Verbrauch in den Abendstunde",
                     details = "In diesem Profil findet sich vor allem beleuchtungsorientierter Stromverbrauch. Solche Betriebe sind gekennzeichnet durch einen an den Werktagen (vor allem in der dunklen Jahreszeit) eher untergeordneten Tagesbedarf und einem in den Abendstunden liegenden Verbrauchsschwerpunkt. Hierzu gehören z.B. Tankstellen und Geschäfte mit erheblicher Schaufensterfläche. In dieses Profil sind auch Abendgaststätten und Freizeiteinrichtungen einzuordnen, soweit ihr Verbrauchsschwerpunkt nicht am Wochenende liegt, z.B. Fitneß- und Sonnenstudios, Jugendzentren (vgl. auch G6)."),
           G3 = list(profile = "G3", description = "Gewerbe durchlaufend",
                     details = "Hier finden sich Verbrauchsstellen, die das ganze Jahr und auch im Wochenverlauf einen relativ gleichmäßigen Verbrauch mit einem spürbaren durchlaufenden Sockel haben. Beispiele sind Kläranlagen, Trinkwasser-Pumpen, Gemeinschaftsanlagen in Wohnanlagen, Kühlhäuser, Läden mit erheblichem Bedarf an Kühlung, Anlagen mit Zwangsbelüftung (z.B. Parkhäuser)."),
           G4 = list(profile = "G4", description = "Laden/ Friseur",
                     details = "Dies sind Verbrauchsstellen, die fast ausschließlich von den Ladenöffnungszeiten (Werktag bis abends und auch am Samstag bis nachmittags) bestimmt sind. Dies ist das typische Profil für Läden aller Art. Ein ähnliches Profil weisen Friseurbetriebe auf. Unterschiede durch z.B. einzelne Nachmittage ohne Geschäftsbetrieb fallen bezogen auf die Gesamtgruppe kaum ins Gewicht. Die teilweise bis 20 Uhr verlängerten Ladenöffnungszeiten haben ebenso nur geringen Einfluß, da sich die Effekte des Geschäftsbetriebs mit denen der abendlichen Ladenbeleuchtung vermischen."),
           G5 = list(profile = "G5", description = "Bäckerei mit Backstube",
                     details = "Bäckereien mit Backstube haben den Schwerpunkt ihres Verbrauchs an den Werktagen traditionell ab ca. 3 Uhr früh und in der Nacht zum Samstag ab etwa Mitternacht. Der Tagverbrauch ist zum Gesamtbedarf relativ gering und wird hauptsächlich von der Verkaufstätigkeit bestimmt. Verkaufsorientierte Bäckereien, in denen zu Geschäftszeiten Backwaren zubereitet werden ('Backen im Laden'), verhalten sich wie andere Läden und sind im Profil G4 einzuordnen."),
           G6 = list(profile = "G6", description = "Wochenendbetrieb",
                     details = "Betriebe mit deutlichen Verbrauchsschwerpunkt an den Wochenenden. Das sind insbesondere alle durch die Freizeitaktivitäten der Bevölkerung geprägten Geschäfte: Jugendclubs, Ausflugs- und Speisegaststätten, Tankstellen mit Waschanlagen, Kinos mit Verzehr, Sport- und Freizeiteinrichtungen."),
           L0 = list(profile = "L0", description = "Landwirtschaftsbetriebe allgemein",
                     details = "Erfolgt keine Unterscheidung der Landwirtschaftsbetriebe nach L1 oder L2 und kann keine Einordnung in eines der charakteristischen Gewerbe-Profile erfolgen, so kann mit guter Näherung dieses Profil verwendet werden. Es stellt den gewichteten Mittelwert der Gesamtgruppe für landwirtschaftliche Betriebe nach der repräsentativ für das Versorgungsgebiet der RWE Energie AG im Jahr 1992 gezogenen Stichprobe dar."),
           L1 = list(profile = "L1", description = "Landwirtschaftsbetriebe mit Milchwirtschaft/ Nebenerwerbs-Tierzucht",
                     details = "Der Stromverbrauch von Milchviehbetrieben ist geprägt durch das zweimalige Melken und das anschließende Herunterkühlen der Milch. Ähnliches Verhalten zeigen Nebenerwerbsbetriebe mit z.B. Schweineaufzucht: Hier wird am frühen Morgen und am Abend (vor bzw. nach dem Haupterwerb) durch die Fütterungsvorgänge Stromverbrauch ausgelöst. Bei großen Haupterwerbsbetrieben mit Tierzucht verteilen sich solche Vorgänge auf die klassischen Arbeitsstunden, so daß das passende Gewerbe-Profil zu wählen ist."),
           L2 = list(profile = "L2", description = "Übrige Landwirtschaftsbetriebe",
                     details = "Traditionell findet sich bei den meisten westdeutschen Betrieben ein Nebeneinander von Haushalt und Produktion. Für solche Betriebe ist dieses mittlere Profil anzuwenden. Soweit in einem landwirtschaftlichen Betrieb eine weitgehend tageszeitenunabhängige Produktion vorliegt (z.B. Tierproduktionsanlagen in Ostdeutschland), ist das passende Gewerbe-Profil zu wählen."))

EN <- list(H0 = list(profile = "H0", description = "household", details = "This profile includes all households with exclusively and predominantly private consumption. Households with predominantly private electrical consumption, i.e. also with minor commercial consumption are e.g. sales representatives, home workers, etc. with an office in the household. The Household profile is not applicable for special applications such as storage heaters or heat pumps."),
           G0 = list(profile = "G0", description = "commerce in general",
                     details = "If an assignment to one of the profiles G1 to G6 is not possible or desired, this profile represents the weighted average of the overall group."),
           G1 = list(profile = "G1", description = "commerce workday from 8am - 6pm",
                     details = "This profile represents consumers that typically use electricity between around 8 a.m. and 6 p.m. on weekdays, with little or no consumption on weekends (otherwise see G4). These include offices, doctors' offices, law firms, workshops, print shops, schools, kindergartens and daycare centers, administrative facilities and branch banks."),
           G2 = list(profile = "G2", description = "commerce with predominant consumption in evening hours",
                     details = "This profile mainly includes illumination-intensive electricity consumption. Such businesses are characterized by a rather subordinate daily demand on working days (especially in the winter season) and a consumption focus in the evening hours. These include, for example, petrol stations and stores with a large display window area, also evening restaurants and leisure facilities, as long as their consumption focus is not on weekends, e.g. fitness and tanning studios, youth centers (see also G6)."),
           G3 = list(profile = "G3", description = "commerce continous",
                     details = "These are consumers that have a relatively constant consumption throughout the year and also over the course of the week, with a noticeable constant base load. Examples include sewage treatment plants, drinking water pumps, communal facilities in residential complexes, cold stores, stores with considerable cooling requirements, facilities with forced ventilation (e.g. parking garages)."),
           G4 = list(profile = "G4", description = "shop / barbershop",
                     details = "These are consumers that are almost exclusively characterized by store opening hours (workday until the evening, on Saturday until the afternoon). This is the typical profile for stores of all kinds. Hairdressers also have a similar profile. Differences due to e.g. individual afternoons without business operations are hardly significant in relation to the overall group. Store opening hours, some of which are extended to 8 p.m., also have little influence, as the effects of business operations are mixed with those of evening store lighting."),
           G5 = list(profile = "G5", description = "bakery with bakehouse",
                     details = "Bakeries with a bakery traditionally have their main consumption on weekdays from around 3 a.m. and on Saturday nights from around midnight. Daytime consumption is relatively low compared to overall demand and is mainly determined by sales activities. Sales-oriented bakeries in which bakery products are prepared during business hours ('in-store baking') behave like other stores and are classified in profile G4."),
           G6 = list(profile = "G6", description = "weekend business",
                     details = "Commercial facilities with a clear focus on consumption at weekends. In particular, these are all businesses characterized by the leisure activities of the population: youth clubs, restaurants and cafés, petrol stations with car washes, cinemas with food outlets, sports and leisure facilities."),
           L0 = list(profile = "L0", description = "agricultural in general",
                     details = "If there is no differentiation of farms according to profiles L1 or L2 and no classification into one of the characteristic commercial profiles can be made, this profile can be used as a good approximation. It represents the weighted average value of the total group for agricultural enterprises according to the sample drawn in 1992 to represent the RWE Energie AG energy supply area."),
           L1 = list(profile = "L1", description = "agricultural with dairy farming / part-time livestock farming",
                     details = "The electricity consumption of dairy farms is characterized by the double milking and subsequent cooling of the milk. Part-time farms with e.g. pig rearing show similar behavior: Here, electricity consumption is triggered in the early morning and evening (before and after the main farm respectively) by the feeding processes. In the case of large main farms with animal husbandry, such processes are distributed over the classic working hours, so that the appropriate commercial profile must be selected."),
           L2 = list(profile = "L2", description = "other agricultural businesses",
                     details = "Traditionally, most West German companies have a combination of household and production. This average profile should be applied to such farms. If production on a farm is largely independent of the time of day (e.g. animal production facilities in in eastern Germany), the appropriate commercial profile should be selected."))

test_that("info in English as expected", {
  expect_equal(EN["H0"], slp_info("H0", language = "EN"))
})

test_that("info in English as expected", {
  expect_equal(DE["H0"], slp_info("H0", language = "DE"))
})

test_that("info in English as expected", {
  expect_error(slp_info("ABC"), "'profile_id' should be one of 'H0', 'G0', 'G1', 'G2', 'G3', 'G4', 'G5', 'G6', 'L0', 'L1', 'L2'.")
})
