% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages_hclust.R
\name{stages_hclust}
\alias{stages_hclust}
\title{Learn a staged tree with hierarchical clustering}
\usage{
stages_hclust(
  object,
  distance = "totvar",
  k = NA,
  method = "complete",
  ignore = object$name_unobserved,
  limit = length(object$tree),
  scope = NULL,
  score = function(x) {
     return(-BIC(x))
 }
)
}
\arguments{
\item{object}{an object of class \code{sevt} with fitted probabilities and
data, as returned by \code{full} or \code{sevt_fit}.}

\item{distance}{character, the distance measure to be used, either
a possible \code{method} for \code{\link{dist}} or
one of the following: \code{"totvar", "hellinger"}.}

\item{k}{integer or (named) vector: number of clusters, that is stages per variable.
Values will be recycled if needed. If \code{NA} (default) a search of
the number of stage is performed with respect to the maximization of
the \code{score} function. \code{NA} and integer can be mixed
to fix the number of stage for some variables and use the
score to select others.}

\item{method}{the agglomeration method to be used in \code{\link{hclust}}.}

\item{ignore}{vector of stages which will be ignored and left untouched.
By default the name of the unobserved stages stored in
\code{object$name_unobserved}.}

\item{limit}{the maximum number of variables to consider.}

\item{scope}{names of the variables to consider.}

\item{score}{A function. Score to maximize for automatic selection
of the number of stages. Used if \code{k=NA} for some variables.}
}
\value{
A staged event tree object.
}
\description{
Build a stage event tree with \code{k} stages for each variable by
clustering stage probabilities with hierarchical clustering.
}
\details{
\code{hclust_sevt} performs hierarchical clustering
of the initial stage probabilities in \code{object}
and it aggregates them into the specified number
of stages (\code{k}).
A different number of stages for the different variables
in the model can be specified by supplying a (named) vector
via the argument \code{k}.
If \code{k} is \code{NA} for some variables, all
possible number of stages will be checked and the
one that maximize the \code{score} will be selected.
}
\examples{
data("Titanic")
model <- stages_hclust(full(Titanic, join_unobserved = TRUE, lambda = 1), k = 2)
summary(model)

### or search k via BIC minimization
model1 <- stages_hclust(full(Titanic), k = NA)
}
