% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages_hc.R
\name{stages_hc}
\alias{stages_hc}
\title{Hill-climbing}
\usage{
stages_hc(
  object,
  score = function(x) {
     return(-BIC(x))
 },
  max_iter = Inf,
  scope = NULL,
  ignore = object$name_unobserved,
  trace = 0
)
}
\arguments{
\item{object}{an object of class \code{sevt} with fitted probabilities and
data, as returned by \code{full} or \code{sevt_fit}.}

\item{score}{the score function to be maximized.}

\item{max_iter}{the maximum number of iterations per variable.}

\item{scope}{names of variables that should be considered for the optimization}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{object$name_unobserved}.}

\item{trace}{if >0 increasingly amount of info
is printed (via \code{message}).}
}
\value{
The final staged event tree obtained.
}
\description{
Greedy search of staged event trees with
iterative moving of nodes between stages.
}
\details{
For each variable node-moves that best increases the
score are performed until no increase is possible.
A node-move is either changing the stage
associate to a node or move the node to a new stage.

The \code{ignore} argument can be used to specify stages that should not
be affected during the search, that is left untouched.
This is useful for preserving structural zeroes and to speed-up
computations.
}
\examples{
start <- indep(PhDArticles[, 1:5], join_unobserved = TRUE)
model <- stages_hc(start)
}
