% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasadj.R
\name{seasadj.STR}
\alias{seasadj.STR}
\title{Seasonal adjustment based on STR}
\usage{
\method{seasadj}{STR}(object, include = c("Trend", "Random"), ...)
}
\arguments{
\item{object}{Result of STR decomposition.}

\item{include}{Vector of component names to include in the result. The default is \code{c("Trend", "Random")}.}

\item{...}{Other arguments not currently used.}
}
\description{
\code{seasadj.STR} extracts seasonally adjusted data by removing the seasonal components from the result of STR decomposition.
}
\examples{
\donttest{
fit <- AutoSTR(log(grocery))
plot(seasadj(fit))
}
}
\seealso{
\code{\link{STRmodel}}, \code{\link{RSTRmodel}}, \code{\link{STR}}, \code{\link{AutoSTR}}
}
\author{
Alexander Dokumentov
}
