% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plotting.R
\name{calculate_conditional_prob}
\alias{calculate_conditional_prob}
\title{Calculate Conditional Probability in a Chain Event Graph (CEG)}
\usage{
calculate_conditional_prob(
  path_df,
  unique_values,
  selected_indices,
  last_group
)
}
\arguments{
\item{path_df}{A data frame containing paths and their corresponding products,
as returned by the \code{calculate_path_products} function.}

\item{unique_values}{A character vector containing the unique values (e.g., labels or categories)
to condition on.}

\item{selected_indices}{A numeric vector of indices corresponding to the groupings of the unique values.}

\item{last_group}{A string representing the last group for which the conditional probability is to be calculated.}
}
\value{
A numeric value representing the conditional probability P(last_group | unique_values).
}
\description{
This function calculates the conditional probability of a specified group of conditions occurring,
given a set of unique values, based on the calculated path products.
}
