% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcu_shapefile.R
\docType{data}
\name{bcu_shapefile}
\alias{bcu_shapefile}
\title{London Basic Command Units (BCUs)}
\format{
A \code{sf} object with 13 features and 1 field:
\describe{
\item{BCU}{Name of the Basic Command Unit (character)}
\item{geometry}{MULTIPOLYGON geometry column in BNG projection}
}
}
\source{
Merged from Borough shapefile from London Datastore.
}
\usage{
bcu_shapefile
}
\description{
A simple features (\code{sf}) object containing the spatial boundaries of London's Basic Command Units (BCUs),
used for policing. The dataset includes BCU names and their corresponding MULTIPOLYGON geometries.
The data is projected in the British National Grid (EPSG:27700).
}
\examples{
library(sf)
plot(st_geometry(bcu_shapefile))

}
\keyword{datasets}
\keyword{sf}
\keyword{spatial}
