% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_as_dataset.R
\name{spm_as_dataset}
\alias{spm_as_dataset}
\alias{spm_as_dataset,data.frame,ANY,ANY,ANY,missingOrNULL-method}
\alias{spm_as_dataset,data.frame,ANY,ANY,ANY,list-method}
\alias{spm_as_dataset,data.frame,ANY,ANY,ANY,character-method}
\alias{spm_as_dataset,sf,ANY,ANY,ANY,ANY-method}
\title{Create a \code{sspm_dataset} dataset structure}
\usage{
spm_as_dataset(data, name, time, uniqueID, coords = NULL, ...)

\S4method{spm_as_dataset}{data.frame,ANY,ANY,ANY,missingOrNULL}(
  data,
  name,
  time,
  uniqueID,
  coords,
  crs = NULL,
  boundaries = NULL,
  biomass = NULL,
  density = NULL,
  biomass_units = NULL,
  density_units = NULL
)

\S4method{spm_as_dataset}{data.frame,ANY,ANY,ANY,list}(
  data,
  name,
  time,
  uniqueID,
  coords,
  crs = NULL,
  boundaries = NULL,
  biomass = NULL,
  density = NULL,
  biomass_units = "kg",
  density_units = "kg/km^2"
)

\S4method{spm_as_dataset}{data.frame,ANY,ANY,ANY,character}(
  data,
  name,
  time,
  uniqueID,
  coords,
  crs = NULL,
  boundaries = NULL,
  biomass = NULL,
  density = NULL,
  biomass_units = "kg",
  density_units = "kg/km^2"
)

\S4method{spm_as_dataset}{sf,ANY,ANY,ANY,ANY}(
  data,
  name,
  time,
  uniqueID,
  coords,
  crs = NULL,
  boundaries = NULL,
  biomass = NULL,
  density = NULL,
  biomass_units = "kg",
  density_units = "kg/km^2"
)
}
\arguments{
\item{data}{\strong{[data.frame OR sf]} The dataset.}

\item{name}{\strong{[character]} The name of the dataset, default to "Biomass".}

\item{time}{\strong{[character]} The column of \code{data} for the temporal
dimensions (i.e. year).}

\item{uniqueID}{\strong{[character]} The column of \code{data} that is unique for all
rows of the data matrix.}

\item{coords}{\strong{[character]} The column of \code{data} for longitude and
latitude of the observations.}

\item{...}{Arguments passed onto methods.}

\item{crs}{Coordinate reference system, passed onto \link[sf]{st_as_sf}.}

\item{boundaries}{\strong{[sspm_boundary]} An object of class
\link[=sspm_boundary-class]{sspm_discrete_boundary}.}

\item{biomass}{\strong{[character]} Columns to be encoded as biomasses (required).}

\item{density}{\strong{[character]} Columns to be encoded as densities (optionnal).}

\item{biomass_units}{\strong{[character]} Units for biomass columns, default to "kg".}

\item{density_units}{\strong{[character]} Units for density columns, default to "kg/km^2".}
}
\value{
An object of class \code{\link[=sspm_dataset-class]{sspm_dataset}}.
}
\description{
This casts a \code{data.frame} or \code{sf} object into  an object of class
\code{\link[=sspm_dataset-class]{sspm_dataset}}. This object is the format the package
uses to manage and manipulate the modeling data.
}
\examples{
data(borealis_simulated, package = "sspm")
biomass_dataset <- spm_as_dataset(data.frame(borealis_simulated), name = "borealis",
                                  density = "weight_per_km2",
                                  time = "year_f",
                                  coords = c('lon_dec','lat_dec'),
                                  uniqueID = "uniqueID")
biomass_dataset

}
