% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.sspm}
\alias{plot,sspm_boundary,missing-method}
\alias{plot,sspm_dataset,missing-method}
\alias{plot,sspm_fit,missing-method}
\title{Plot \code{sspm} objects}
\usage{
\S4method{plot}{sspm_boundary,missing}(x, y, ...)

\S4method{plot}{sspm_dataset,missing}(
  x,
  y,
  ...,
  var = NULL,
  point_size = 1,
  line_size = 1,
  use_sf = FALSE,
  interval = FALSE,
  page = "first",
  nrow = 2,
  ncol = 2,
  log = FALSE,
  scales = "fixed",
  show_PI = TRUE,
  show_CI = TRUE
)

\S4method{plot}{sspm_fit,missing}(
  x,
  y,
  ...,
  point_size = 1,
  line_size = 1,
  train_test = FALSE,
  biomass = NULL,
  next_ts = FALSE,
  smoothed_biomass = FALSE,
  aggregate = FALSE,
  interval = FALSE,
  biomass_origin = NULL,
  use_sf = FALSE,
  page = "first",
  nrow = 2,
  ncol = 2,
  log = FALSE,
  scales = "fixed",
  show_PI = TRUE,
  show_CI = TRUE
)
}
\arguments{
\item{x}{\strong{[sspm_...]} An object from this package.}

\item{y}{NOT USED (from generic).}

\item{...}{NOT USED (from generic).}

\item{var}{\strong{[character]} (For sspm_dataset) Variable to plot.}

\item{point_size}{\strong{[numeric]} Passed on to ggplot size parameter for
point size.}

\item{line_size}{\strong{[numeric]} Passed on to ggplot size parameter for line
size.}

\item{use_sf}{\strong{[logical]} Whether to produce a spatial plot.}

\item{interval}{\strong{[logical]} (For sspm_fit & sspm_dataset) Whether to plot
CI and PI intervals.}

\item{page}{The page to draw}

\item{nrow}{Number of rows per page}

\item{ncol}{Number of columns per page}

\item{log}{\strong{[logical]} For productivity, whether to plot log productivity,
(default to FALSE) for others, whether to plot on a log scale (default to TRUE).}

\item{scales}{Are scales shared across all facets (the default,
\code{"fixed"}), or do they vary across rows (\code{"free_x"}),
columns (\code{"free_y"}), or both rows and columns (\code{"free"})?}

\item{show_PI}{\strong{[character]} Whether to show the PIs.}

\item{show_CI}{\strong{[character]} Whether to show the CIs.}

\item{train_test}{\strong{[logical]} (For sspm_fit) Whether to plot a train/test
pair plot.}

\item{biomass}{\strong{[character]} (For sspm_fit) The biomass variable for
predictions.}

\item{next_ts}{\strong{[logical]} (For sspm_fit) Whether to plot a predictions
for next timestep.}

\item{smoothed_biomass}{\strong{[logical]} (For sspm_fit) Whether to plot a the
smoothed biomass used for predictions.}

\item{aggregate}{\strong{[logical]} (For sspm_fit) For biomass predictions only,
whether to aggregate the data to the boundary level. Default to FALSE.}

\item{biomass_origin}{\strong{[character]} Biomass variable to plot (from
original dataset, optionnal).}
}
\value{
A ggplot2 plot object.
}
\description{
Plot methods for a range of sspm objects.
}
\examples{
\dontrun{
# To plot a boundary object and visualize patches/points
plot(sspm_boundary)
# To plot a dataset variable
plot(biomass_smooth, var = "weight_per_km2", log = FALSE)
plot(biomass_smooth, var = "weight_per_km2", use_sf = TRUE)
# To plot a fitted model
# Test-train plot
plot(sspm_model_fit, train_test = TRUE, scales = "free")
# Timeseries plot
plot(sspm_model_fit, log = T, scales = 'free')
plot(sspm_model_fit, log = T, use_sf = TRUE)
plot(sspm_model_fit, biomass = "weight_per_km2_borealis",  scales = "free")
plot(sspm_model_fit, biomass = "weight_per_km2_borealis", use_sf = TRUE)
plot(sspm_model_fit, biomass = "weight_per_km2_borealis",
     next_ts = TRUE, aggregate = TRUE, scales = "free", interval = T)
}

}
