% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.HeckmantS.R
\name{summary.HeckmantS}
\alias{summary.HeckmantS}
\title{Summary of Heckman-t Model}
\usage{
\method{summary}{HeckmantS}(object, ...)
}
\arguments{
\item{object}{An object of class \code{HeckmantS}, containing the
fitted model results.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Prints to the console:
\itemize{
  \item Model fit statistics (log-likelihood, AIC, BIC, number of observations).
  \item Coefficient tables with standard errors and significance stars.
}
Invisibly returns \code{NULL}.
}
\description{
Prints a detailed summary of the parameter estimates and model fit
statistics for an object of class \code{HeckmantS}.
}
\details{
This method displays the maximum likelihood estimation results
for the Heckman sample selection model with Student's t-distributed errors.
It includes separate coefficient tables for:
\itemize{
  \item Selection equation (Probit model),
  \item Outcome equation,
  \item Error terms (including \code{sigma}, \code{rho}, and \code{df}).
}
Model fit statistics (log-likelihood, AIC, BIC, and number of observations)
are also provided for model evaluation.
}
\examples{
\dontrun{
data(MEPS2001)
attach(MEPS2001)
selectEq <- dambexp ~ age + female + educ + blhisp + totchr + ins + income
outcomeEq <- lnambx ~ age + female + educ + blhisp + totchr + ins
model <- HeckmantS(selectEq, outcomeEq, data = MEPS2001, df = 12)
summary(model)
}

}
\seealso{
\code{\link{HeckmantS}}
}
