% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssifs.R
\name{ssifs}
\alias{ssifs}
\title{Stochastic Search Inconsistency Factor Selection}
\usage{
ssifs(
  TE,
  seTE,
  treat1,
  treat2,
  studlab,
  ref,
  method = "DBT",
  rpcons = TRUE,
  pcons = 0.5,
  zellner = TRUE,
  c = 3,
  psi = NULL,
  digits = 4,
  M = 50000,
  B = 10000,
  n_thin = 1,
  n_chains = 2,
  M_pilot = 10000,
  B_pilot = 2000,
  n_thin_pilot = 1,
  n_chains_pilot = 1
)
}
\arguments{
\item{TE}{Estimate of treatment effect (e.g. log odds ratio, mean difference, or log hazard ratio).}

\item{seTE}{Standard error of the treatment estimate.}

\item{treat1}{Label/Number of the first treatment.}

\item{treat2}{Label/Number of the second treatment.}

\item{studlab}{Study labels.}

\item{ref}{Reference treatment.}

\item{method}{Method used for the specification of the inconsistency factors; Possible choices are: \itemize{
\item \code{"LuAdes"} for the Lu & Ades model (Lu & Ades, 2006)
\item \code{"DBT"} for the design-by-treatment method (Higgins et al., 2012)
\item \code{"Jackson"} for the random-effects implementation of the design-by-treatment model (Jackson et al., 2014)}}

\item{rpcons}{\code{"logical"}. If \code{TRUE}, an informative beta distribution Beta(157, 44) is used for the probability to have a consistent network.}

\item{pcons}{Probability to have a consistent network.}

\item{zellner}{\code{"logical"}. If \code{TRUE}, Zellner g-prior is used for the dependency between the inconsistency factors. If \code{FALSE}, inconsistency factors assumed independent.}

\item{c}{Tuning parameter.}

\item{psi}{Tuning parameter.}

\item{digits}{Digits of the exported results.}

\item{M}{Number of NMA MCMC iterations.}

\item{B}{Burn-in period of the NMA MCMC run.}

\item{n_thin}{Thinning interval of the NMA MCMC run.}

\item{n_chains}{Number of parallel chains for the NMA MCMC run.}

\item{M_pilot}{Number of pilot MCMC iterations.}

\item{B_pilot}{Burn-in period of the pilot MCMC run.}

\item{n_thin_pilot}{Thinning interval of the pilot MCMC run.}

\item{n_chains_pilot}{Number of parallel chains for the pilot MCMC run.}
}
\value{
A list containing the following components:
\item{MCMC_run}{An object of class \code{rjags} containing the MCMC run of the NMA model.}
\item{Bayes_Factor}{Bayes factor of the consistent NMA model over the inconsistent NMA model.}
\item{Posterior_inclusion_probabilities}{A \code{data.frame} containing the posterior inclusion
probabilities of the inconsistency factors. Columns \code{Comparison} and \code{Design} denote in which comparisons
inconsistency factors are added. When argument \code{method = "LuAdes"}, column \code{Design} is \code{NA},
because only loop inconsistencies are accounted.
\code{PIP} denotes the estimated posterior inclusion probability, \code{b} the estimated median effect
 of the inconsistency factors, \code{b.lb} and \code{b.ub} the lower and upper bounds of the inconsistency factors' effect estimates,
 respectively.}
\item{Posterior_Odds}{A \code{data.frame} containing the model posterior odds. Column \code{IFs} denotes
 in which comparisons inconsistency factors are added, \code{Freq} the number of times the model is observed in
 the MCMC run, \code{f(m|y)} the posterior model probability and \code{PO_IFCONS} the posterior model odds
 of the consistent NMA model (denoted as \code{NO IFs}) over the corresponding inconsistent NMA model.}
\item{Summary}{A \code{data.frame} containing the summary estimates of the MCMC run of the NMA model.}
\item{Z_matrix}{A \code{data.frame} containing in the first 3 columns the treatment comparisons used for
 the Z matrix and the Z matrix in the rest columns.}
\item{disconnected_studies}{A vector with the studies that were excluded in order to have
 a connected network.}
\item{n_subnetworks}{Number of sub-networks.}
\item{subnetworks}{A list with the sub-networks of the original NMA data.}
}
\description{
Stochastic Search Inconsistency Factor Selection evaluates the consistency assumption of Network Meta-Analysis in the Bayesian framework,
by treating the inconsistency detection as a variable selection problem. The consistency assumption is evaluated locally, but also globally.
}
\details{
Stochastic Search Inconsistency Factor Selection (SSIFS) is the extension of Stochastic Search Variable Selection (SSVS)
(George & McCulloch, 1993) for identifying inconsistencies in Network Meta-Analysis (NMA).

SSIFS (Seitidis et al., 2023), is a two-step method in which the inconsistency factors are specified in the first step, and in the second step,
SSVS is performed on the inconsistency factors. The method used for the specification of the inconsistency factors, is
controlled by the argument \code{method}. Among the choices that may be considered are the Lu and Ades model (Lu & Ades, 2006),
the design-by-treatment model (Higgins et al., 2012), and the random-effects implementation of the design-by-treatment model (Jackson et al., 2014).

After specifying the inconsistency factors, the random-effects NMA model is implemented in the Bayesian framework using the \code{R2jags} package.
An uninformative normal is assumed for the prior distribution of the treatment effects, while for the heterogeneity parameter tau, an uninformative half-normal is assumed.
The function provides the MCMC run of the NMA model (item \code{MCMC_run}), whereby the user can check the convergence of the MCMC run.

SSIFS by default assumes that inconsistency factors are dependent by using a Zellner g-prior to describe this dependency (\code{zellner = TRUE}).
Parameter g in the Zellner g-prior is specified using the unit information criterion (Kass & Wasserman, 1995), which is translated in
SSIFS to the total number of observed comparisons that are included in the network. By setting the argument \code{zellner = FALSE}, inconsistency factors are assumed independent.
Regarding the inclusion probabilities, the function by default assumes an informative Beta distribution (Beta(157, 44)) for the probability to have a
consistent network (\code{rpcons = TRUE}). In the case where \code{rpcons = FALSE}, this probability is assumed fixed and equal to 0.5 (\code{pcons = 0.5}).
The user can modify this probability through the argument \code{pcons}.

Tuning parameters in SSIFS are specified by the arguments \code{c} and \code{psi}. They should be specified in a way that, when
an inconsistency factor is included in the NMA model, the corresponding coefficient lies in an area close to zero,
and far away from this area when it is not included in the NMA model. Regarding the argument \code{c}, values between 10 and 100
usually perform well in most cases. Argument \code{psi} can be obtained either from a pilot MCMC run of the NMA model, as the
standard deviation of the inconsistency factors (\code{psi = NULL}), or can be set fixed a-priory by the analyst.

In order to evaluate the consistency assumption, we can examine \itemize{
\item {the posterior inclusion probabilities
of the inconsistency factors (item \code{Posterior_inclusion_probabilities})}
\item{the posterior model probabilities (item \code{Posterior_Odds})}
\item{the posterior model odds (item \code{Posterior_Odds})}
\item{the Bayes factor of the consistent NMA model over the inconsistent NMA models (item \code{Bayes_Factor})} }
A posterior inclusion probability above 0.5 indicates inconsistency.
Also, an inconsistent NMA model with large posterior model probability suggests the presence of inconsistency. Item \code{Bayes_Factor}
provides a global test for testing the consistency assumption, by calculating the Bayes factor of the consistent NMA model (model without inconsistency factors) over the
rest inconsistent NMA models that  were observed in the MCMC run. An estimate above 1 favors the consistent NMA model.
For the calculation of the Bayes factor, the inconsistent NMA models are treated as a single model and the corresponding
posterior model probabilities are summed.
}
\note{
The function uses the random-effects inverse-variance NMA model, and assumes common heterogeneity between different treatment comparisons
and no correlation between different studies. Additionally, when the network is disconnected, the function keeps only those studies that
belong to the largest sub-network.

In a multi-arm study with T comparisons, T-1 are required for the NMA model since the rest are obtained as a linear combination.
The function automatically excludes the unnecessary comparisons, while maintaining the basic comparisons (if possible)
and comparisons in which an inconsistency factor has been added. Therefore, all possible comparisons
of multi-arm studies must be provided by the user.

For the names of the inconsistency factor, treatments are separated by the symbol \code{" ; "}. For example, if an inconsistency
factor is added in the comparison between treatments A and B, the inconsistency factor name will be \code{A ; B}.
In the case where \code{method = "DBT"} or \code{method = "Jackson"}, inconsistency factors' names for multi-arm designs are
denoted as \emph{treatment.comparison}_\emph{design}. Thus, if an inconsistency factor is added in the comparison
between treatments A and B of the ABC design, the inconsistency factor name will be \code{A ; B_ABC}.

In extremely large networks, the number of paths between two nodes may be exponentially high. If your network is lattice-like,
you may run out of memory during the specification of the inconsistency factors with the Lu and Ades model.
}
\examples{
data(Alcohol)

TE <- Alcohol$TE
seTE <- Alcohol$seTE
studlab <- Alcohol$studyid
treat1 <- Alcohol$treat2
treat2 <- Alcohol$treat1

# Stochastic Search Inconsistency Factor Selection using intervention AO-CT as reference.
m <- ssifs(TE, seTE, treat1, treat2, studlab, ref = "AO-CT", M=1000, B=100)


}
\references{
George, E. I., & McCulloch, R. E. (1993):
Variable selection via Gibbs sampling.
\emph{Journal of the American Statistical Association},
\bold{88}(423), 881-889.

Seitidis, G., Nikolakopoulos, S., Ntzoufras, I., & Mavridis, D. (2023):
Inconsistency identification in network meta-analysis via stochastic search variable selection.
\emph{Statistics in Medicine},
\bold{42}(26), 4850–4866.

Lu, G., & Ades, A. E. (2006):
Assessing evidence inconsistency in mixed treatment comparisons.
\emph{Journal of the American Statistical Association},
\bold{101}(474), 447-459.

Higgins, J. P. T., Jackson, D., Barrett, J. K., Lu, G., Ades, A. E., & White, I. R. (2012):
Consistency and inconsistency in network meta-analysis: concepts and models for multi-arm studies.
\emph{Research synthesis methods},
\bold{3}(2), 98-110.

Jackson, D., Barrett, J. K., Rice, S., White, I. R., & Higgins, J. P. (2014):
A design-by-treatment interaction model for network meta-analysis with random inconsistency effects.
\emph{Statistics in medicine},
\bold{33}(21), 3639-3654.

Kass, R. E., & Wasserman, L. (1995):
A Reference Bayesian Test for Nested Hypotheses and its Relationship to the Schwarz Criterion.
\emph{Journal of the American Statistical Association},
\bold{90}(431), 928–934.
}
