% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anzg_metolachlor_fresh.R
\docType{data}
\name{anzg_metolachlor_fresh}
\alias{anzg_metolachlor_fresh}
\title{Species Sensitivity Data for metolachlor_fresh}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl},
\code{data.frame}) with 21 rows and 10 columns.
}
\usage{
anzg_metolachlor_fresh
}
\description{
ANZG Species Sensitivity Data provided by the Department of Agriculture
Water and the Environment, Australia for metolachlor in fresh water.
}
\details{
These data are licensed under CC BY 4.0 (summary of terms provided here:
\url{https://creativecommons.org/licenses/by/4.0/}) Additional information
is available from the Water Quality website at
\url{https://www.waterquality.gov.au/}

Please cite these data as:
\insertRef{anzg_toxicant_2020}{ssddata}

The columns are as follows:

\describe{
\item{Conc}{The chemical concentration in micrograms per Litre (dbl).}
\item{Duration}{The duration of the test in days (dbl).}
\item{Genus}{The Genus name (chr).}
\item{Group}{The taxonomic group (chr).}
\item{Life_stage}{Life stage of the test organism (chr).}
\item{Notes}{Other notes (chr).}
\item{Phylum}{The Phylum name (chr).}
\item{Species}{The species binomial name (chr).}
\item{Test_endpoint}{The test endpoint measure (chr).}
\item{Toxicity_measure}{The toxicity measure used (chr).}

Where toxicity measure is not a chronic NEC, EC10 or NOEC value,
concentration has been converted using the appropriate default ratio, as
follows: 10 from acute EC50/LC50 to chronic EC10; 5 from chronic EC50 to
EC10; 2.5 from LOEC to EC10. Please see the primary reference material for
more information. }
}
\examples{

print(anzg_metolachlor_fresh, n=Inf)

}
\keyword{datasets}
