// Generated by rstantools.  Do not edit by hand.

/*
    ssMousetrack is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ssMousetrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ssMousetrack.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_fit_model_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 127> locations_array__ =
  {" (found before start of program)",
  " (in 'fit_model', line 47, column 2 to column 19)",
  " (in 'fit_model', line 50, column 2 to column 28)",
  " (in 'fit_model', line 51, column 2 to column 27)",
  " (in 'fit_model', line 52, column 2 to column 42)",
  " (in 'fit_model', line 53, column 2 to column 41)",
  " (in 'fit_model', line 54, column 2 to column 41)",
  " (in 'fit_model', line 55, column 2 to column 24)",
  " (in 'fit_model', line 56, column 2 to column 30)",
  " (in 'fit_model', line 57, column 2 to column 16)",
  " (in 'fit_model', line 58, column 2 to column 20)",
  " (in 'fit_model', line 59, column 2 to column 30)",
  " (in 'fit_model', line 60, column 2 to column 16)",
  " (in 'fit_model', line 62, column 2 to column 14)",
  " (in 'fit_model', line 65, column 2 to column 34)",
  " (in 'fit_model', line 66, column 2 to column 35)",
  " (in 'fit_model', line 67, column 2 to column 32)",
  " (in 'fit_model', line 72, column 6 to column 29)",
  " (in 'fit_model', line 73, column 6 to column 48)",
  " (in 'fit_model', line 75, column 6 to column 88)",
  " (in 'fit_model', line 70, column 11 to line 76, column 5)",
  " (in 'fit_model', line 70, column 4 to line 76, column 5)",
  " (in 'fit_model', line 78, column 4 to column 50)",
  " (in 'fit_model', line 79, column 4 to column 65)",
  " (in 'fit_model', line 80, column 4 to column 63)",
  " (in 'fit_model', line 81, column 4 to column 46)",
  " (in 'fit_model', line 82, column 4 to column 40)",
  " (in 'fit_model', line 84, column 4 to column 60)",
  " (in 'fit_model', line 85, column 4 to column 70)",
  " (in 'fit_model', line 69, column 15 to line 86, column 3)",
  " (in 'fit_model', line 69, column 2 to line 86, column 3)",
  " (in 'fit_model', line 101, column 35 to column 93)",
  " (in 'fit_model', line 101, column 9 to column 93)",
  " (in 'fit_model', line 100, column 35 to column 92)",
  " (in 'fit_model', line 100, column 9 to line 101, column 93)",
  " (in 'fit_model', line 99, column 35 to column 91)",
  " (in 'fit_model', line 99, column 9 to line 101, column 93)",
  " (in 'fit_model', line 98, column 35 to column 81)",
  " (in 'fit_model', line 98, column 9 to line 101, column 93)",
  " (in 'fit_model', line 97, column 35 to column 77)",
  " (in 'fit_model', line 97, column 9 to line 101, column 93)",
  " (in 'fit_model', line 96, column 37 to column 134)",
  " (in 'fit_model', line 96, column 114 to column 132)",
  " (in 'fit_model', line 96, column 95 to column 113)",
  " (in 'fit_model', line 96, column 9 to line 101, column 93)",
  " (in 'fit_model', line 95, column 35 to column 92)",
  " (in 'fit_model', line 95, column 9 to line 101, column 93)",
  " (in 'fit_model', line 94, column 30 to column 90)",
  " (in 'fit_model', line 94, column 4 to line 101, column 93)",
  " (in 'fit_model', line 93, column 16 to line 102, column 3)",
  " (in 'fit_model', line 93, column 2 to line 102, column 3)",
  " (in 'fit_model', line 107, column 4 to column 60)",
  " (in 'fit_model', line 106, column 15 to line 108, column 3)",
  " (in 'fit_model', line 106, column 2 to line 108, column 3)",
  " (in 'fit_model', line 30, column 2 to column 8)",
  " (in 'fit_model', line 31, column 2 to column 8)",
  " (in 'fit_model', line 32, column 2 to column 8)",
  " (in 'fit_model', line 33, column 2 to column 9)",
  " (in 'fit_model', line 34, column 8 to column 9)",
  " (in 'fit_model', line 34, column 18 to column 21)",
  " (in 'fit_model', line 34, column 2 to column 25)",
  " (in 'fit_model', line 35, column 8 to column 9)",
  " (in 'fit_model', line 35, column 18 to column 21)",
  " (in 'fit_model', line 35, column 2 to column 26)",
  " (in 'fit_model', line 36, column 18 to column 19)",
  " (in 'fit_model', line 36, column 2 to column 28)",
  " (in 'fit_model', line 37, column 29 to column 32)",
  " (in 'fit_model', line 37, column 2 to column 41)",
  " (in 'fit_model', line 38, column 9 to column 12)",
  " (in 'fit_model', line 38, column 13 to column 15)",
  " (in 'fit_model', line 38, column 2 to column 19)",
  " (in 'fit_model', line 39, column 18 to column 21)",
  " (in 'fit_model', line 39, column 2 to column 25)",
  " (in 'fit_model', line 40, column 18 to column 21)",
  " (in 'fit_model', line 40, column 2 to column 34)",
  " (in 'fit_model', line 41, column 9 to column 12)",
  " (in 'fit_model', line 41, column 13 to column 14)",
  " (in 'fit_model', line 41, column 2 to column 19)",
  " (in 'fit_model', line 42, column 2 to column 25)",
  " (in 'fit_model', line 43, column 2 to column 25)",
  " (in 'fit_model', line 44, column 9 to column 11)",
  " (in 'fit_model', line 44, column 2 to column 29)",
  " (in 'fit_model', line 47, column 9 to column 11)",
  " (in 'fit_model', line 50, column 8 to column 9)",
  " (in 'fit_model', line 50, column 18 to column 19)",
  " (in 'fit_model', line 51, column 8 to column 9)",
  " (in 'fit_model', line 51, column 18 to column 19)",
  " (in 'fit_model', line 52, column 8 to column 9)",
  " (in 'fit_model', line 52, column 27 to column 28)",
  " (in 'fit_model', line 53, column 8 to column 9)",
  " (in 'fit_model', line 53, column 27 to column 28)",
  " (in 'fit_model', line 54, column 8 to column 9)",
  " (in 'fit_model', line 54, column 27 to column 30)",
  " (in 'fit_model', line 55, column 9 to column 12)",
  " (in 'fit_model', line 56, column 8 to column 9)",
  " (in 'fit_model', line 56, column 18 to column 21)",
  " (in 'fit_model', line 57, column 9 to column 12)",
  " (in 'fit_model', line 58, column 9 to column 12)",
  " (in 'fit_model', line 59, column 9 to column 12)",
  " (in 'fit_model', line 60, column 9 to column 12)",
  " (in 'fit_model', line 4, column 11 to column 12)",
  " (in 'fit_model', line 4, column 13 to column 14)",
  " (in 'fit_model', line 4, column 4 to column 18)",
  " (in 'fit_model', line 5, column 11 to column 14)",
  " (in 'fit_model', line 5, column 4 to column 22)",
  " (in 'fit_model', line 7, column 6 to column 36)",
  " (in 'fit_model', line 6, column 17 to line 7, column 37)",
  " (in 'fit_model', line 6, column 4 to line 7, column 37)",
  " (in 'fit_model', line 8, column 4 to column 26)",
  " (in 'fit_model', line 9, column 4 to column 17)",
  " (in 'fit_model', line 3, column 55 to line 10, column 3)",
  " (in 'fit_model', line 13, column 11 to column 12)",
  " (in 'fit_model', line 13, column 13 to column 14)",
  " (in 'fit_model', line 13, column 4 to column 18)",
  " (in 'fit_model', line 14, column 11 to column 14)",
  " (in 'fit_model', line 14, column 4 to column 22)",
  " (in 'fit_model', line 16, column 6 to column 30)",
  " (in 'fit_model', line 15, column 17 to line 16, column 31)",
  " (in 'fit_model', line 15, column 4 to line 16, column 31)",
  " (in 'fit_model', line 17, column 4 to column 26)",
  " (in 'fit_model', line 18, column 4 to column 17)",
  " (in 'fit_model', line 12, column 55 to line 19, column 3)",
  " (in 'fit_model', line 22, column 4 to column 20)",
  " (in 'fit_model', line 23, column 4 to column 25)",
  " (in 'fit_model', line 24, column 4 to column 25)",
  " (in 'fit_model', line 25, column 4 to column 107)",
  " (in 'fit_model', line 21, column 55 to line 26, column 3)"};
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_J(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__);
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_I(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__>,-1,1>
rescale_data(const T0__& x_arg__, const T1__& min_x, const T2__& max_x,
             std::ostream* pstream__);
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_J(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 100;
    stan::math::validate_non_negative_index("X", "I", I);
    current_statement__ = 101;
    stan::math::validate_non_negative_index("X", "J", J);
    Eigen::Matrix<local_scalar_t__,-1,-1> X =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(I, J, DUMMY_VAR__);
    current_statement__ = 103;
    stan::math::validate_non_negative_index("x_vec", "I * J", (I * J));
    Eigen::Matrix<local_scalar_t__,-1,1> x_vec =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant((I * J), DUMMY_VAR__);
    current_statement__ = 107;
    for (int i = 1; i <= I; ++i) {
      current_statement__ = 105;
      stan::model::assign(X,
        stan::math::rep_row_vector(
          stan::model::rvalue(x, "x", stan::model::index_uni(i)), J),
        "assigning variable X", stan::model::index_uni(i));
    }
    current_statement__ = 108;
    stan::model::assign(x_vec,
      stan::math::to_vector(stan::math::transpose(X)),
      "assigning variable x_vec");
    current_statement__ = 109;
    return x_vec;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T2__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T2__>>,-1,1>
kronecker_simplified_I(const int& I, const int& J, const T2__& x_arg__,
                       std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 111;
    stan::math::validate_non_negative_index("X", "I", I);
    current_statement__ = 112;
    stan::math::validate_non_negative_index("X", "J", J);
    Eigen::Matrix<local_scalar_t__,-1,-1> X =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(I, J, DUMMY_VAR__);
    current_statement__ = 114;
    stan::math::validate_non_negative_index("x_vec", "I * J", (I * J));
    Eigen::Matrix<local_scalar_t__,-1,1> x_vec =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant((I * J), DUMMY_VAR__);
    current_statement__ = 118;
    for (int i = 1; i <= I; ++i) {
      current_statement__ = 116;
      stan::model::assign(X, stan::math::to_row_vector(x),
        "assigning variable X", stan::model::index_uni(i));
    }
    current_statement__ = 119;
    stan::model::assign(x_vec,
      stan::math::to_vector(stan::math::transpose(X)),
      "assigning variable x_vec");
    current_statement__ = 120;
    return x_vec;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__>,-1,1>
rescale_data(const T0__& x_arg__, const T1__& min_x, const T2__& max_x,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__, T2__>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int I = std::numeric_limits<int>::min();
    current_statement__ = 122;
    I = stan::math::rows(x);
    local_scalar_t__ max_Vx = DUMMY_VAR__;
    current_statement__ = 123;
    max_Vx = stan::math::max(x);
    local_scalar_t__ min_Vx = DUMMY_VAR__;
    current_statement__ = 124;
    min_Vx = stan::math::min(x);
    current_statement__ = 125;
    return stan::math::add(stan::math::rep_vector(min_x, I),
             stan::math::elt_multiply(
               stan::math::elt_divide(stan::math::subtract(x, min_Vx),
                 stan::math::rep_vector((max_Vx - min_Vx), I)),
               stan::math::rep_vector((max_x - min_x), I)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_fit_model final : public model_base_crtp<model_fit_model> {
private:
  int I;
  int N;
  int J;
  int KK;
  std::vector<Eigen::Matrix<double,-1,1>> Y;
  std::vector<Eigen::Matrix<double,-1,1>> DY;
  Eigen::Matrix<double,-1,1> sigmaz_data__;
  Eigen::Matrix<double,-1,-1> bnds_data__;
  Eigen::Matrix<double,-1,-1> D_data__;
  Eigen::Matrix<double,-1,1> a_data__;
  Eigen::Matrix<double,-1,1> lambda_vec_data__;
  Eigen::Matrix<double,-1,-1> Am_data__;
  double kappa_lb;
  double kappa_ub;
  Eigen::Matrix<double,-1,-1> priors_matrix_data__;
  int sigma_kf_2dim__;
  int kappa_vec_1dim__;
  int y_star_2dim__;
  int G_1dim__;
  int z_vec_1dim__;
  int lambda_pred_vec_1dim__;
  int b_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> sigmaz{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> bnds{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> D{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> a{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> lambda_vec{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Am{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> priors_matrix{nullptr, 0, 0};
public:
  ~model_fit_model() {}
  model_fit_model(stan::io::var_context& context__, unsigned int
                  random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_fit_model_namespace::model_fit_model";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 54;
      context__.validate_dims("data initialization", "I", "int",
        std::vector<size_t>{});
      I = std::numeric_limits<int>::min();
      current_statement__ = 54;
      I = context__.vals_i("I")[(1 - 1)];
      current_statement__ = 55;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 55;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 56;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 56;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 57;
      context__.validate_dims("data initialization", "KK", "int",
        std::vector<size_t>{});
      KK = std::numeric_limits<int>::min();
      current_statement__ = 57;
      KK = context__.vals_i("KK")[(1 - 1)];
      current_statement__ = 58;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("Y", "I * J", (I * J));
      current_statement__ = 60;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N),
          static_cast<size_t>((I * J))});
      Y = std::vector<Eigen::Matrix<double,-1,1>>(N,
            Eigen::Matrix<double,-1,1>::Constant((I * J),
              std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 60;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= (I * J); ++sym1__) {
          current_statement__ = 60;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 60;
            stan::model::assign(Y, Y_flat__[(pos__ - 1)],
              "assigning variable Y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 60;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 61;
      stan::math::validate_non_negative_index("DY", "N", N);
      current_statement__ = 62;
      stan::math::validate_non_negative_index("DY", "I * J", (I * J));
      current_statement__ = 63;
      context__.validate_dims("data initialization", "DY", "double",
        std::vector<size_t>{static_cast<size_t>(N),
          static_cast<size_t>((I * J))});
      DY = std::vector<Eigen::Matrix<double,-1,1>>(N,
             Eigen::Matrix<double,-1,1>::Constant((I * J),
               std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> DY_flat__;
        current_statement__ = 63;
        DY_flat__ = context__.vals_r("DY");
        current_statement__ = 63;
        pos__ = 1;
        current_statement__ = 63;
        for (int sym1__ = 1; sym1__ <= (I * J); ++sym1__) {
          current_statement__ = 63;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 63;
            stan::model::assign(DY, DY_flat__[(pos__ - 1)],
              "assigning variable DY", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 63;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 64;
      stan::math::validate_non_negative_index("sigmaz", "I", I);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "sigmaz", "double",
        std::vector<size_t>{static_cast<size_t>(I)});
      sigmaz_data__ = Eigen::Matrix<double,-1,1>::Constant(I,
                        std::numeric_limits<double>::quiet_NaN());
      new (&sigmaz)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sigmaz_data__.data(), I);
      {
        std::vector<local_scalar_t__> sigmaz_flat__;
        current_statement__ = 65;
        sigmaz_flat__ = context__.vals_r("sigmaz");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          current_statement__ = 65;
          stan::model::assign(sigmaz, sigmaz_flat__[(pos__ - 1)],
            "assigning variable sigmaz", stan::model::index_uni(sym1__));
          current_statement__ = 65;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "sigmaz", sigmaz, 0);
      current_statement__ = 66;
      stan::math::validate_non_negative_index("bnds", "I * J", (I * J));
      current_statement__ = 67;
      context__.validate_dims("data initialization", "bnds", "double",
        std::vector<size_t>{static_cast<size_t>((I * J)),
          static_cast<size_t>(3)});
      bnds_data__ = Eigen::Matrix<double,-1,-1>::Constant((I * J), 3,
                      std::numeric_limits<double>::quiet_NaN());
      new (&bnds) Eigen::Map<Eigen::Matrix<double,-1,-1>>(bnds_data__.data(),
        (I * J), 3);
      {
        std::vector<local_scalar_t__> bnds_flat__;
        current_statement__ = 67;
        bnds_flat__ = context__.vals_r("bnds");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 67;
          for (int sym2__ = 1; sym2__ <= (I * J); ++sym2__) {
            current_statement__ = 67;
            stan::model::assign(bnds, bnds_flat__[(pos__ - 1)],
              "assigning variable bnds", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 67;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "bnds", bnds, 0);
      current_statement__ = 67;
      stan::math::check_less_or_equal(function__, "bnds", bnds,
        stan::math::pi());
      current_statement__ = 68;
      stan::math::validate_non_negative_index("D", "I * J", (I * J));
      current_statement__ = 69;
      stan::math::validate_non_negative_index("D", "KK", KK);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "D", "double",
        std::vector<size_t>{static_cast<size_t>((I * J)),
          static_cast<size_t>(KK)});
      D_data__ = Eigen::Matrix<double,-1,-1>::Constant((I * J), KK,
                   std::numeric_limits<double>::quiet_NaN());
      new (&D) Eigen::Map<Eigen::Matrix<double,-1,-1>>(D_data__.data(), (I *
        J), KK);
      {
        std::vector<local_scalar_t__> D_flat__;
        current_statement__ = 70;
        D_flat__ = context__.vals_r("D");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
          current_statement__ = 70;
          for (int sym2__ = 1; sym2__ <= (I * J); ++sym2__) {
            current_statement__ = 70;
            stan::model::assign(D, D_flat__[(pos__ - 1)],
              "assigning variable D", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 70;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 71;
      stan::math::validate_non_negative_index("a", "I * J", (I * J));
      current_statement__ = 72;
      context__.validate_dims("data initialization", "a", "double",
        std::vector<size_t>{static_cast<size_t>((I * J))});
      a_data__ = Eigen::Matrix<double,-1,1>::Constant((I * J),
                   std::numeric_limits<double>::quiet_NaN());
      new (&a) Eigen::Map<Eigen::Matrix<double,-1,1>>(a_data__.data(), (I *
        J));
      {
        std::vector<local_scalar_t__> a_flat__;
        current_statement__ = 72;
        a_flat__ = context__.vals_r("a");
        current_statement__ = 72;
        pos__ = 1;
        current_statement__ = 72;
        for (int sym1__ = 1; sym1__ <= (I * J); ++sym1__) {
          current_statement__ = 72;
          stan::model::assign(a, a_flat__[(pos__ - 1)],
            "assigning variable a", stan::model::index_uni(sym1__));
          current_statement__ = 72;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 72;
      stan::math::check_greater_or_equal(function__, "a", a, 0);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("lambda_vec", "I * J", (I * J));
      current_statement__ = 74;
      context__.validate_dims("data initialization", "lambda_vec", "double",
        std::vector<size_t>{static_cast<size_t>((I * J))});
      lambda_vec_data__ = Eigen::Matrix<double,-1,1>::Constant((I * J),
                            std::numeric_limits<double>::quiet_NaN());
      new (&lambda_vec)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(lambda_vec_data__.data(), (I *
        J));
      {
        std::vector<local_scalar_t__> lambda_vec_flat__;
        current_statement__ = 74;
        lambda_vec_flat__ = context__.vals_r("lambda_vec");
        current_statement__ = 74;
        pos__ = 1;
        current_statement__ = 74;
        for (int sym1__ = 1; sym1__ <= (I * J); ++sym1__) {
          current_statement__ = 74;
          stan::model::assign(lambda_vec, lambda_vec_flat__[(pos__ - 1)],
            "assigning variable lambda_vec", stan::model::index_uni(sym1__));
          current_statement__ = 74;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 74;
      stan::math::check_greater_or_equal(function__, "lambda_vec",
        lambda_vec, 0);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("Am", "I * J", (I * J));
      current_statement__ = 76;
      stan::math::validate_non_negative_index("Am", "I", I);
      current_statement__ = 77;
      context__.validate_dims("data initialization", "Am", "double",
        std::vector<size_t>{static_cast<size_t>((I * J)),
          static_cast<size_t>(I)});
      Am_data__ = Eigen::Matrix<double,-1,-1>::Constant((I * J), I,
                    std::numeric_limits<double>::quiet_NaN());
      new (&Am) Eigen::Map<Eigen::Matrix<double,-1,-1>>(Am_data__.data(), (I
        * J), I);
      {
        std::vector<local_scalar_t__> Am_flat__;
        current_statement__ = 77;
        Am_flat__ = context__.vals_r("Am");
        current_statement__ = 77;
        pos__ = 1;
        current_statement__ = 77;
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          current_statement__ = 77;
          for (int sym2__ = 1; sym2__ <= (I * J); ++sym2__) {
            current_statement__ = 77;
            stan::model::assign(Am, Am_flat__[(pos__ - 1)],
              "assigning variable Am", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 77;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 78;
      context__.validate_dims("data initialization", "kappa_lb", "double",
        std::vector<size_t>{});
      kappa_lb = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 78;
      kappa_lb = context__.vals_r("kappa_lb")[(1 - 1)];
      current_statement__ = 78;
      stan::math::check_greater_or_equal(function__, "kappa_lb", kappa_lb, 0);
      current_statement__ = 79;
      context__.validate_dims("data initialization", "kappa_ub", "double",
        std::vector<size_t>{});
      kappa_ub = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 79;
      kappa_ub = context__.vals_r("kappa_ub")[(1 - 1)];
      current_statement__ = 79;
      stan::math::check_greater_or_equal(function__, "kappa_ub", kappa_ub, 0);
      current_statement__ = 80;
      stan::math::validate_non_negative_index("priors_matrix", "KK", KK);
      current_statement__ = 81;
      context__.validate_dims("data initialization", "priors_matrix",
        "double",
        std::vector<size_t>{static_cast<size_t>(KK), static_cast<size_t>(5)});
      priors_matrix_data__ = Eigen::Matrix<double,-1,-1>::Constant(KK, 5,
                               std::numeric_limits<double>::quiet_NaN());
      new (&priors_matrix)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(priors_matrix_data__.data(),
        KK, 5);
      {
        std::vector<local_scalar_t__> priors_matrix_flat__;
        current_statement__ = 81;
        priors_matrix_flat__ = context__.vals_r("priors_matrix");
        current_statement__ = 81;
        pos__ = 1;
        current_statement__ = 81;
        for (int sym1__ = 1; sym1__ <= 5; ++sym1__) {
          current_statement__ = 81;
          for (int sym2__ = 1; sym2__ <= KK; ++sym2__) {
            current_statement__ = 81;
            stan::model::assign(priors_matrix, priors_matrix_flat__[(pos__ -
              1)], "assigning variable priors_matrix",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 81;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 82;
      stan::math::validate_non_negative_index("gamma", "KK", KK);
      current_statement__ = 83;
      stan::math::validate_non_negative_index("z_pred", "N", N);
      current_statement__ = 84;
      stan::math::validate_non_negative_index("z_pred", "I", I);
      current_statement__ = 85;
      stan::math::validate_non_negative_index("z_upd", "N", N);
      current_statement__ = 86;
      stan::math::validate_non_negative_index("z_upd", "I", I);
      current_statement__ = 87;
      stan::math::validate_non_negative_index("lambda_pred", "N", N);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("lambda_pred", "I", I);
      current_statement__ = 89;
      stan::math::validate_non_negative_index("lambda_upd", "N", N);
      current_statement__ = 90;
      stan::math::validate_non_negative_index("lambda_upd", "I", I);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("sigma_kf", "N", N);
      current_statement__ = 92;
      sigma_kf_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 92;
      sigma_kf_2dim__ = (I * J);
      current_statement__ = 92;
      stan::math::validate_non_negative_index("sigma_kf", "I * J",
        sigma_kf_2dim__);
      current_statement__ = 93;
      kappa_vec_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 93;
      kappa_vec_1dim__ = (I * J);
      current_statement__ = 93;
      stan::math::validate_non_negative_index("kappa_vec", "I * J",
        kappa_vec_1dim__);
      current_statement__ = 94;
      stan::math::validate_non_negative_index("y_star", "N", N);
      current_statement__ = 95;
      y_star_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 95;
      y_star_2dim__ = (I * J);
      current_statement__ = 95;
      stan::math::validate_non_negative_index("y_star", "I * J",
        y_star_2dim__);
      current_statement__ = 96;
      G_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 96;
      G_1dim__ = (I * J);
      current_statement__ = 96;
      stan::math::validate_non_negative_index("G", "I * J", G_1dim__);
      current_statement__ = 97;
      z_vec_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 97;
      z_vec_1dim__ = (I * J);
      current_statement__ = 97;
      stan::math::validate_non_negative_index("z_vec", "I * J", z_vec_1dim__);
      current_statement__ = 98;
      lambda_pred_vec_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 98;
      lambda_pred_vec_1dim__ = (I * J);
      current_statement__ = 98;
      stan::math::validate_non_negative_index("lambda_pred_vec", "I * J",
        lambda_pred_vec_1dim__);
      current_statement__ = 99;
      b_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 99;
      b_1dim__ = (I * J);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("b", "I * J", b_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = KK;
  }
  inline std::string model_name() const final {
    return "model_fit_model";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_fit_model_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(KK, DUMMY_VAR__);
      current_statement__ = 1;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(KK);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> z_pred =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(I, DUMMY_VAR__));
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> z_upd =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(I, DUMMY_VAR__));
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> lambda_pred =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(I, DUMMY_VAR__));
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> lambda_upd =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(I, DUMMY_VAR__));
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> sigma_kf =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(sigma_kf_2dim__,
            DUMMY_VAR__));
      Eigen::Matrix<local_scalar_t__,-1,1> kappa_vec =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(kappa_vec_1dim__,
          DUMMY_VAR__);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> y_star =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(y_star_2dim__,
            DUMMY_VAR__));
      Eigen::Matrix<local_scalar_t__,-1,1> G =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G_1dim__, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> z_vec =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(z_vec_1dim__,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda_pred_vec =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(lambda_pred_vec_1dim__,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> b =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(b_1dim__, DUMMY_VAR__);
      current_statement__ = 13;
      stan::model::assign(b, stan::math::multiply(D, gamma),
        "assigning variable b");
      current_statement__ = 14;
      stan::model::assign(z_pred, stan::math::rep_vector(1e-04, I),
        "assigning variable z_pred", stan::model::index_uni(1));
      current_statement__ = 15;
      stan::model::assign(lambda_pred, stan::math::rep_vector(1, I),
        "assigning variable lambda_pred", stan::model::index_uni(1));
      current_statement__ = 16;
      stan::model::assign(kappa_vec, stan::math::rep_vector(1, (I * J)),
        "assigning variable kappa_vec");
      current_statement__ = 30;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 21;
        if (stan::math::logical_gt(n, 1)) {
          current_statement__ = 17;
          stan::model::assign(z_pred,
            stan::model::rvalue(z_upd, "z_upd",
              stan::model::index_uni((n - 1))), "assigning variable z_pred",
            stan::model::index_uni(n));
          current_statement__ = 18;
          stan::model::assign(lambda_pred,
            stan::math::add(
              stan::model::rvalue(lambda_upd, "lambda_upd",
                stan::model::index_uni((n - 1))), sigmaz),
            "assigning variable lambda_pred", stan::model::index_uni(n));
          current_statement__ = 19;
          stan::model::assign(kappa_vec,
            stan::math::sqrt(
              stan::math::elt_divide(1,
                rescale_data(
                  stan::math::exp(
                    stan::math::elt_multiply(lambda_vec,
                      stan::model::rvalue(DY, "DY", stan::model::index_uni(n)))),
                  kappa_lb, kappa_ub, pstream__))),
            "assigning variable kappa_vec");
        }
        current_statement__ = 22;
        stan::model::assign(z_vec,
          kronecker_simplified_J(I, J,
            stan::model::rvalue(z_pred, "z_pred", stan::model::index_uni(n)),
            pstream__), "assigning variable z_vec");
        current_statement__ = 23;
        stan::model::assign(lambda_pred_vec,
          kronecker_simplified_J(I, J,
            stan::model::rvalue(lambda_pred, "lambda_pred",
              stan::model::index_uni(n)), pstream__),
          "assigning variable lambda_pred_vec");
        current_statement__ = 24;
        stan::model::assign(y_star,
          stan::math::add(
            stan::model::rvalue(bnds, "bnds", stan::model::index_omni(),
              stan::model::index_uni(1)),
            stan::math::elt_divide(
              stan::model::rvalue(bnds, "bnds", stan::model::index_omni(),
                stan::model::index_uni(3)),
              stan::math::add(1,
                stan::math::exp(stan::math::subtract(b, z_vec))))),
          "assigning variable y_star", stan::model::index_uni(n));
        current_statement__ = 25;
        stan::model::assign(sigma_kf,
          stan::math::add(lambda_pred_vec, kappa_vec),
          "assigning variable sigma_kf", stan::model::index_uni(n));
        current_statement__ = 26;
        stan::model::assign(G,
          stan::math::elt_divide(lambda_pred_vec,
            stan::model::rvalue(sigma_kf, "sigma_kf",
              stan::model::index_uni(n))), "assigning variable G");
        current_statement__ = 27;
        stan::model::assign(z_upd,
          stan::math::add(
            stan::model::rvalue(z_pred, "z_pred", stan::model::index_uni(n)),
            stan::math::transpose(
              stan::math::multiply(
                stan::math::transpose(
                  stan::math::elt_multiply(
                    stan::math::subtract(
                      stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
                      stan::model::rvalue(y_star, "y_star",
                        stan::model::index_uni(n))), G)), Am))),
          "assigning variable z_upd", stan::model::index_uni(n));
        current_statement__ = 28;
        stan::model::assign(lambda_upd,
          stan::math::subtract(
            stan::model::rvalue(lambda_pred, "lambda_pred",
              stan::model::index_uni(n)),
            stan::math::transpose(
              stan::math::multiply(
                stan::math::transpose(
                  stan::math::elt_multiply(
                    stan::math::elt_multiply(G,
                      stan::model::rvalue(sigma_kf, "sigma_kf",
                        stan::model::index_uni(n))), G)), Am))),
          "assigning variable lambda_upd", stan::model::index_uni(n));
      }
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "lambda_pred",
        lambda_pred, 0);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "lambda_upd",
        lambda_upd, 0);
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "sigma_kf", sigma_kf, 0);
      {
        current_statement__ = 50;
        for (int k = 1; k <= KK; ++k) {
          current_statement__ = 48;
          if (stan::math::logical_eq(
                stan::model::rvalue(priors_matrix, "priors_matrix",
                  stan::model::index_uni(k), stan::model::index_uni(1)), 1)) {
            current_statement__ = 47;
            lp_accum__.add(stan::math::lognormal_lpdf<propto__>(
                             stan::model::rvalue(gamma, "gamma",
                               stan::model::index_uni(k)),
                             stan::model::rvalue(priors_matrix,
                               "priors_matrix", stan::model::index_uni(k),
                               stan::model::index_uni(2)),
                             stan::model::rvalue(priors_matrix,
                               "priors_matrix", stan::model::index_uni(k),
                               stan::model::index_uni(3))));
          } else {
            current_statement__ = 46;
            if (stan::math::logical_eq(
                  stan::model::rvalue(priors_matrix, "priors_matrix",
                    stan::model::index_uni(k), stan::model::index_uni(1)), 2)) {
              current_statement__ = 45;
              lp_accum__.add(stan::math::normal_lpdf<propto__>(
                               stan::model::rvalue(gamma, "gamma",
                                 stan::model::index_uni(k)),
                               stan::model::rvalue(priors_matrix,
                                 "priors_matrix", stan::model::index_uni(k),
                                 stan::model::index_uni(2)),
                               stan::model::rvalue(priors_matrix,
                                 "priors_matrix", stan::model::index_uni(k),
                                 stan::model::index_uni(3))));
            } else {
              current_statement__ = 44;
              if (stan::math::logical_eq(
                    stan::model::rvalue(priors_matrix, "priors_matrix",
                      stan::model::index_uni(k), stan::model::index_uni(1)),
                    201)) {
                current_statement__ = 41;
                lp_accum__.add(stan::math::normal_lpdf<propto__>(
                                 stan::model::rvalue(gamma, "gamma",
                                   stan::model::index_uni(k)),
                                 stan::model::rvalue(priors_matrix,
                                   "priors_matrix",
                                   stan::model::index_uni(k),
                                   stan::model::index_uni(2)),
                                 stan::model::rvalue(priors_matrix,
                                   "priors_matrix",
                                   stan::model::index_uni(k),
                                   stan::model::index_uni(3))));
                current_statement__ = 43;
                if (stan::math::logical_lt(
                      stan::model::rvalue(gamma, "gamma",
                        stan::model::index_uni(k)),
                      stan::model::rvalue(priors_matrix, "priors_matrix",
                        stan::model::index_uni(k), stan::model::index_uni(4)))) {
                  current_statement__ = 43;
                  lp_accum__.add(stan::math::negative_infinity());
                } else {
                  current_statement__ = 42;
                  if (stan::math::logical_gt(
                        stan::model::rvalue(gamma, "gamma",
                          stan::model::index_uni(k)),
                        stan::model::rvalue(priors_matrix, "priors_matrix",
                          stan::model::index_uni(k),
                          stan::model::index_uni(5)))) {
                    current_statement__ = 42;
                    lp_accum__.add(stan::math::negative_infinity());
                  } else {
                    current_statement__ = 42;
                    lp_accum__.add(-stan::math::log_diff_exp(
                                      stan::math::normal_lcdf(
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(5)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(2)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(3))),
                                      stan::math::normal_lcdf(
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(4)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(2)),
                                        stan::model::rvalue(priors_matrix,
                                          "priors_matrix",
                                          stan::model::index_uni(k),
                                          stan::model::index_uni(3)))));
                  }
                }
              } else {
                current_statement__ = 40;
                if (stan::math::logical_eq(
                      stan::model::rvalue(priors_matrix, "priors_matrix",
                        stan::model::index_uni(k), stan::model::index_uni(1)),
                      3)) {
                  current_statement__ = 39;
                  lp_accum__.add(stan::math::chi_square_lpdf<propto__>(
                                   stan::model::rvalue(gamma, "gamma",
                                     stan::model::index_uni(k)),
                                   stan::model::rvalue(priors_matrix,
                                     "priors_matrix",
                                     stan::model::index_uni(k),
                                     stan::model::index_uni(2))));
                } else {
                  current_statement__ = 38;
                  if (stan::math::logical_eq(
                        stan::model::rvalue(priors_matrix, "priors_matrix",
                          stan::model::index_uni(k),
                          stan::model::index_uni(1)), 4)) {
                    current_statement__ = 37;
                    lp_accum__.add(stan::math::inv_chi_square_lpdf<propto__>(
                                     stan::model::rvalue(gamma, "gamma",
                                       stan::model::index_uni(k)),
                                     stan::model::rvalue(priors_matrix,
                                       "priors_matrix",
                                       stan::model::index_uni(k),
                                       stan::model::index_uni(2))));
                  } else {
                    current_statement__ = 36;
                    if (stan::math::logical_eq(
                          stan::model::rvalue(priors_matrix, "priors_matrix",
                            stan::model::index_uni(k),
                            stan::model::index_uni(1)), 5)) {
                      current_statement__ = 35;
                      lp_accum__.add(stan::math::gamma_lpdf<propto__>(
                                       stan::model::rvalue(gamma, "gamma",
                                         stan::model::index_uni(k)),
                                       stan::model::rvalue(priors_matrix,
                                         "priors_matrix",
                                         stan::model::index_uni(k),
                                         stan::model::index_uni(2)),
                                       stan::model::rvalue(priors_matrix,
                                         "priors_matrix",
                                         stan::model::index_uni(k),
                                         stan::model::index_uni(3))));
                    } else {
                      current_statement__ = 34;
                      if (stan::math::logical_eq(
                            stan::model::rvalue(priors_matrix,
                              "priors_matrix", stan::model::index_uni(k),
                              stan::model::index_uni(1)), 6)) {
                        current_statement__ = 33;
                        lp_accum__.add(stan::math::pareto_lpdf<propto__>(
                                         stan::model::rvalue(gamma, "gamma",
                                           stan::model::index_uni(k)),
                                         stan::model::rvalue(priors_matrix,
                                           "priors_matrix",
                                           stan::model::index_uni(k),
                                           stan::model::index_uni(2)),
                                         stan::model::rvalue(priors_matrix,
                                           "priors_matrix",
                                           stan::model::index_uni(k),
                                           stan::model::index_uni(3))));
                      } else {
                        current_statement__ = 32;
                        if (stan::math::logical_eq(
                              stan::model::rvalue(priors_matrix,
                                "priors_matrix", stan::model::index_uni(k),
                                stan::model::index_uni(1)), 7)) {
                          current_statement__ = 31;
                          lp_accum__.add(stan::math::uniform_lpdf<propto__>(
                                           stan::model::rvalue(gamma,
                                             "gamma",
                                             stan::model::index_uni(k)),
                                           stan::model::rvalue(priors_matrix,
                                             "priors_matrix",
                                             stan::model::index_uni(k),
                                             stan::model::index_uni(2)),
                                           stan::model::rvalue(priors_matrix,
                                             "priors_matrix",
                                             stan::model::index_uni(k),
                                             stan::model::index_uni(3))));
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        current_statement__ = 53;
        for (int n = 1; n <= N; ++n) {
          current_statement__ = 51;
          lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(
                           stan::model::rvalue(Y, "Y",
                             stan::model::index_uni(n)),
                           stan::model::rvalue(y_star, "y_star",
                             stan::model::index_uni(n)),
                           stan::math::diag_matrix(
                             stan::model::rvalue(sigma_kf, "sigma_kf",
                               stan::model::index_uni(n)))));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_fit_model_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> gamma =
        Eigen::Matrix<double,-1,1>::Constant(KK,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(KK);
      std::vector<Eigen::Matrix<double,-1,1>> z_pred =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(I,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> z_upd =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(I,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> lambda_pred =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(I,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> lambda_upd =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(I,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> sigma_kf =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(sigma_kf_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      Eigen::Matrix<double,-1,1> kappa_vec =
        Eigen::Matrix<double,-1,1>::Constant(kappa_vec_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<Eigen::Matrix<double,-1,1>> y_star =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(y_star_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      Eigen::Matrix<double,-1,1> G =
        Eigen::Matrix<double,-1,1>::Constant(G_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> z_vec =
        Eigen::Matrix<double,-1,1>::Constant(z_vec_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> lambda_pred_vec =
        Eigen::Matrix<double,-1,1>::Constant(lambda_pred_vec_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> b =
        Eigen::Matrix<double,-1,1>::Constant(b_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(gamma);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 13;
      stan::model::assign(b, stan::math::multiply(D, gamma),
        "assigning variable b");
      current_statement__ = 14;
      stan::model::assign(z_pred, stan::math::rep_vector(1e-04, I),
        "assigning variable z_pred", stan::model::index_uni(1));
      current_statement__ = 15;
      stan::model::assign(lambda_pred, stan::math::rep_vector(1, I),
        "assigning variable lambda_pred", stan::model::index_uni(1));
      current_statement__ = 16;
      stan::model::assign(kappa_vec, stan::math::rep_vector(1, (I * J)),
        "assigning variable kappa_vec");
      current_statement__ = 30;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 21;
        if (stan::math::logical_gt(n, 1)) {
          current_statement__ = 17;
          stan::model::assign(z_pred,
            stan::model::rvalue(z_upd, "z_upd",
              stan::model::index_uni((n - 1))), "assigning variable z_pred",
            stan::model::index_uni(n));
          current_statement__ = 18;
          stan::model::assign(lambda_pred,
            stan::math::add(
              stan::model::rvalue(lambda_upd, "lambda_upd",
                stan::model::index_uni((n - 1))), sigmaz),
            "assigning variable lambda_pred", stan::model::index_uni(n));
          current_statement__ = 19;
          stan::model::assign(kappa_vec,
            stan::math::sqrt(
              stan::math::elt_divide(1,
                rescale_data(
                  stan::math::exp(
                    stan::math::elt_multiply(lambda_vec,
                      stan::model::rvalue(DY, "DY", stan::model::index_uni(n)))),
                  kappa_lb, kappa_ub, pstream__))),
            "assigning variable kappa_vec");
        }
        current_statement__ = 22;
        stan::model::assign(z_vec,
          kronecker_simplified_J(I, J,
            stan::model::rvalue(z_pred, "z_pred", stan::model::index_uni(n)),
            pstream__), "assigning variable z_vec");
        current_statement__ = 23;
        stan::model::assign(lambda_pred_vec,
          kronecker_simplified_J(I, J,
            stan::model::rvalue(lambda_pred, "lambda_pred",
              stan::model::index_uni(n)), pstream__),
          "assigning variable lambda_pred_vec");
        current_statement__ = 24;
        stan::model::assign(y_star,
          stan::math::add(
            stan::model::rvalue(bnds, "bnds", stan::model::index_omni(),
              stan::model::index_uni(1)),
            stan::math::elt_divide(
              stan::model::rvalue(bnds, "bnds", stan::model::index_omni(),
                stan::model::index_uni(3)),
              stan::math::add(1,
                stan::math::exp(stan::math::subtract(b, z_vec))))),
          "assigning variable y_star", stan::model::index_uni(n));
        current_statement__ = 25;
        stan::model::assign(sigma_kf,
          stan::math::add(lambda_pred_vec, kappa_vec),
          "assigning variable sigma_kf", stan::model::index_uni(n));
        current_statement__ = 26;
        stan::model::assign(G,
          stan::math::elt_divide(lambda_pred_vec,
            stan::model::rvalue(sigma_kf, "sigma_kf",
              stan::model::index_uni(n))), "assigning variable G");
        current_statement__ = 27;
        stan::model::assign(z_upd,
          stan::math::add(
            stan::model::rvalue(z_pred, "z_pred", stan::model::index_uni(n)),
            stan::math::transpose(
              stan::math::multiply(
                stan::math::transpose(
                  stan::math::elt_multiply(
                    stan::math::subtract(
                      stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
                      stan::model::rvalue(y_star, "y_star",
                        stan::model::index_uni(n))), G)), Am))),
          "assigning variable z_upd", stan::model::index_uni(n));
        current_statement__ = 28;
        stan::model::assign(lambda_upd,
          stan::math::subtract(
            stan::model::rvalue(lambda_pred, "lambda_pred",
              stan::model::index_uni(n)),
            stan::math::transpose(
              stan::math::multiply(
                stan::math::transpose(
                  stan::math::elt_multiply(
                    stan::math::elt_multiply(G,
                      stan::model::rvalue(sigma_kf, "sigma_kf",
                        stan::model::index_uni(n))), G)), Am))),
          "assigning variable lambda_upd", stan::model::index_uni(n));
      }
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "lambda_pred",
        lambda_pred, 0);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "lambda_upd",
        lambda_upd, 0);
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "sigma_kf", sigma_kf, 0);
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            out__.write(z_pred[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            out__.write(z_upd[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            out__.write(lambda_pred[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
        for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            out__.write(lambda_upd[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
        for (int sym1__ = 1; sym1__ <= sigma_kf_2dim__; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            out__.write(sigma_kf[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
        out__.write(kappa_vec);
        for (int sym1__ = 1; sym1__ <= y_star_2dim__; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            out__.write(y_star[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
        out__.write(G);
        out__.write(z_vec);
        out__.write(lambda_pred_vec);
        out__.write(b);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(KK, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(gamma,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(KK),
        "assigning variable gamma");
      out__.write(gamma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "gamma", "double",
        std::vector<size_t>{static_cast<size_t>(KK)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(KK, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 1;
        gamma_flat__ = context__.vals_r("gamma");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(gamma, gamma_flat__[(pos__ - 1)],
            "assigning variable gamma", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(gamma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"gamma"};
    if (emit_transformed_parameters__) {
      std::vector<std::string>
        temp{"z_pred", "z_upd", "lambda_pred", "lambda_upd", "sigma_kf",
             "kappa_vec", "y_star", "G", "z_vec", "lambda_pred_vec", "b"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    KK)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(I)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(I)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(I)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(I)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(sigma_kf_2dim__)},
             std::vector<size_t>{static_cast<size_t>(kappa_vec_1dim__)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(y_star_2dim__)},
             std::vector<size_t>{static_cast<size_t>(G_1dim__)},
             std::vector<size_t>{static_cast<size_t>(z_vec_1dim__)},
             std::vector<size_t>{static_cast<size_t>(lambda_pred_vec_1dim__)},
             std::vector<size_t>{static_cast<size_t>(b_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "z_pred" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "z_upd" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "lambda_pred" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "lambda_upd" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= sigma_kf_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "sigma_kf" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= kappa_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "kappa_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= y_star_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "y_star" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= G_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "G" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= z_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "z_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= lambda_pred_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambda_pred_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= b_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= KK; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "z_pred" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "z_upd" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "lambda_pred" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "lambda_upd" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= sigma_kf_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "sigma_kf" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= kappa_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "kappa_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= y_star_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "y_star" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= G_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "G" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= z_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "z_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= lambda_pred_vec_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambda_pred_vec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= b_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(KK) + "},\"block\":\"parameters\"},{\"name\":\"z_pred\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"z_upd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"lambda_pred\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"lambda_upd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_kf\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(sigma_kf_2dim__) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"kappa_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(kappa_vec_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_star\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_star_2dim__) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"G\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"z_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(z_vec_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda_pred_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(lambda_pred_vec_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(b_1dim__) + "},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(KK) + "},\"block\":\"parameters\"},{\"name\":\"z_pred\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"z_upd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"lambda_pred\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"lambda_upd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(I) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_kf\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(sigma_kf_2dim__) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"kappa_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(kappa_vec_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_star\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_star_2dim__) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"G\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"z_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(z_vec_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda_pred_vec\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(lambda_pred_vec_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(b_1dim__) + "},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = KK;
    const size_t num_transformed = emit_transformed_parameters *
      ((((((((((((N * I) + (N * I)) + (N * I)) + (N * I)) + (N *
      sigma_kf_2dim__)) + kappa_vec_1dim__) + (N * y_star_2dim__)) +
      G_1dim__) + z_vec_1dim__) + lambda_pred_vec_1dim__) + b_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = KK;
    const size_t num_transformed = emit_transformed_parameters *
      ((((((((((((N * I) + (N * I)) + (N * I)) + (N * I)) + (N *
      sigma_kf_2dim__)) + kappa_vec_1dim__) + (N * y_star_2dim__)) +
      G_1dim__) + z_vec_1dim__) + lambda_pred_vec_1dim__) + b_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_fit_model_namespace::model_fit_model;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_fit_model_namespace::profiles__;
}
#endif
#endif
