% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_data.r
\name{change_pop_bin}
\alias{change_pop_bin}
\title{Set up population length bin structure}
\usage{
change_pop_bin(dat_list, binwidth = NULL, minimum_size = NULL,
  maximum_size = NULL, maximum_age = NULL)
}
\arguments{
\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{binwidth}{A numeric value specifying the width of the size bins.}

\item{minimum_size}{The smallest size bin.}

\item{maximum_size}{The largest size bin.}

\item{maximum_age}{The highest age. Used to structure the maximum age of
the population and the ageing-error matrix, which will be assumed
to have no bias and maximum precision for any added ages.}
}
\value{
A modified Stock Synthesis data file in list form. The list
is only returned if it is assigned to an object.
}
\description{
The population length bins in Stock Synthesis structure size data and
empirical weight-at-age data.
\code{change_pop_bin} changes the data file to contain
specifications to create a vector (length-bin method of 2) rather than
the actual bins from the length data (length-bin method of 1) or
an actual vector (length-bin method of 3).
}
\details{
The only required argument is \code{dat_list} and the remaining arguments
default to a value of \code{NULL}, which leads to the data file not being
changed.
}
