% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_statistics_helpers.R
\name{get_var_est}
\alias{get_var_est}
\title{Get the variance estimates for a survey estimate}
\usage{
get_var_est(
  stat,
  vartype,
  level = 0.95,
  df = Inf,
  pre_calc_ci = FALSE,
  deff = FALSE
)
}
\arguments{
\item{stat}{A survey statistic object, usually the result of a function from the survey
package or svyby.}

\item{vartype}{A vector indicating which variance estimates to calculate (options are
se for standard error, ci for confidence interval, var for variance or cv for
coefficient of variation). Multiples are allowed.}

\item{level}{One or more levels to calculate a confidence interval.}

\item{df}{Degrees of freedom, many survey functions default to Inf, but srvyr functions
generally default to the result of calling degf on the survey object.}

\item{pre_calc_ci}{Whether the confidence interval is pre-calculated (as in svyciprop)}

\item{deff}{Whether to return the design effect (calculated using survey::deff)}
}
\value{
a tbl_svy with the variables modified
}
\description{
This is a helper to allow srvyr's syntactic style. In general, users
will not have to worry about getting survey variance estimates directly
unless they are trying to extend srvyr. This function helps convert from
the result of a survey function into a data.frame with an estimate and
measures of variance around it in a way that summarize expects.
See \code{vignette("extending-srvyr")} for more details.
}
