% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player.R
\name{toggle_my_shuffle}
\alias{toggle_my_shuffle}
\title{Toggle shuffle on or off for user’s playback.}
\usage{
toggle_my_shuffle(
  state,
  device_id = NULL,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{state}{Required. \cr
\code{TRUE}: Shuffle user's playback \cr
\code{FALSE} Do not shuffle user's playback}

\item{device_id}{Optional. The id of the device this command is targeting.
If not supplied, the user’s currently active device is the target.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service.
See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}. The access token must have been issued on behalf of the current user. \cr
The access token must have the \code{user-modify-playback-state} scope authorized
in order to control playback.}
}
\value{
The response from the Spotify Web API on the \code{PUT} request, with a meaningful
error message if the operation was not successful.
}
\description{
Toggle shuffle on or off for user’s playback.
}
\seealso{
Other player functions: 
\code{\link{get_my_current_playback}()},
\code{\link{get_my_currently_playing}()},
\code{\link{get_my_devices}()},
\code{\link{get_my_recently_played}()},
\code{\link{pause_my_playback}()},
\code{\link{seek_to_position}()},
\code{\link{set_my_repeat_mode}()},
\code{\link{skip_my_playback}()},
\code{\link{skip_my_playback_previous}()},
\code{\link{start_my_playback}()},
\code{\link{transfer_my_playback}()}
}
\concept{player functions}
